/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.progress;

import de.intarsys.tools.progress.BaseProgressMonitor;
import de.intarsys.tools.progress.IProgressMonitor;

public class SubProgressMonitor
extends BaseProgressMonitor {
    private final IProgressMonitor parent;
    private float parentWork;
    private float parentWorked;
    private float scale;

    public SubProgressMonitor(IProgressMonitor parent, float parentWork) {
        this.parent = parent;
        this.parentWork = parentWork;
        this.parentWorked = 0.0f;
    }

    @Override
    public void begin(String name, float totalWork) {
        super.begin(name, totalWork);
        this.scale = totalWork <= 0.0f ? 0.0f : this.parentWork / totalWork;
        this.getParent().subTask(name);
    }

    protected String createParentSubTask() {
        Object tempPrefix = this.getTaskName();
        String tempSuffix = this.getSubTaskName();
        if (tempSuffix == null) {
            return tempPrefix;
        }
        if (tempPrefix == null) {
            return tempSuffix;
        }
        if (tempSuffix.startsWith((String)(tempPrefix = (String)tempPrefix + " - "))) {
            return tempSuffix;
        }
        return (String)tempPrefix + tempSuffix;
    }

    @Override
    public void end() {
        super.end();
        if (this.parentWork > this.parentWorked) {
            this.workedParent(this.parentWork - this.parentWorked);
        }
    }

    public IProgressMonitor getParent() {
        return this.parent;
    }

    public double getParentWork() {
        return this.parentWork;
    }

    @Override
    public boolean isCancelled() {
        return this.parent.isCancelled();
    }

    protected void setParentWork(float parentWork) {
        this.parentWork = parentWork;
    }

    @Override
    public void subTask(String name) {
        super.subTask(name);
        this.getParent().subTask(this.createParentSubTask());
    }

    @Override
    public void worked(float work) {
        super.worked(work);
        float realWork = this.scale * work;
        this.workedParent(realWork);
    }

    protected void workedParent(float realWork) {
        if ((realWork = Math.min(realWork, this.parentWork - this.parentWorked)) > 0.0f) {
            this.parentWorked += realWork;
            this.parent.worked(realWork);
        }
    }
}

