/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.preferences;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IArgumentDeclaration;
import de.intarsys.tools.functor.IDeclarationBlock;
import de.intarsys.tools.functor.IDeclarationElement;
import de.intarsys.tools.functor.IDeclarationSupport;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.PreferenceValue;
import de.intarsys.tools.preferences.PreferencesFactory;
import de.intarsys.tools.string.CharacterTools;
import de.intarsys.tools.string.Converter;
import de.intarsys.tools.string.ConverterException;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import java.awt.Rectangle;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;

public class PreferencesTools {
    public static final String ELEMENT_SEPARATOR = ";";
    public static final String KEY_VALUE_SEPARATOR = "=";

    protected static Object convertValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof List) {
            return new Args((List)value);
        }
        if (value instanceof Object[]) {
            return Args.createIndexed((Object[])value);
        }
        try {
            return ConverterRegistry.get().convert(value, PreferenceValue.class);
        }
        catch (ConversionException e) {
            return StringTools.safeString(value);
        }
    }

    protected static String fitLength(String name, int max) {
        int length = name.length();
        if (length <= max) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        char[] chars = new char[length];
        name.getChars(0, length, chars, 0);
        boolean start = true;
        for (int i = 0; i < length; ++i) {
            char c = chars[i];
            if (Character.isUpperCase(c) || c == '.' || c == '_') {
                start = true;
                sb.append(c);
                continue;
            }
            if (CharacterTools.isVowel(c)) {
                if (!start) continue;
                start = false;
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        name = sb.toString();
        length = name.length();
        if (length <= max) {
            return name;
        }
        return name.substring(length - max, length);
    }

    public static <T extends EnumItem> T getEnumItem(IPreferences preferences, EnumMeta<T> meta, String name) {
        if (preferences == null) {
            return meta.getDefault();
        }
        String optionValue = preferences.get(name);
        return meta.getItemOrDefault(optionValue);
    }

    public static <T extends EnumItem> T getEnumItem(IPreferences preferences, EnumMeta<T> meta, String name, String defaultValue) {
        if (preferences == null) {
            return meta.getItemOrDefault(defaultValue);
        }
        String optionValue = preferences.get(name, defaultValue);
        return meta.getItem(optionValue);
    }

    public static String getLarge(IPreferences preferences, String name, String defaultValue) {
        String subKey;
        String subValue;
        if (preferences == null) {
            return defaultValue;
        }
        IPreferences childNode = preferences.node(name);
        int i = 0;
        if ((subValue = childNode.get(subKey = "part" + i++, null)) == null) {
            return defaultValue;
        }
        StringBuilder sb = new StringBuilder();
        while (subValue != null && subValue.length() == 8192) {
            sb.append(subValue);
            subKey = "part" + i++;
            subValue = childNode.get(subKey, null);
        }
        if (subValue != null) {
            sb.append(subValue);
        }
        return sb.toString();
    }

    public static Secret getSecret(IPreferences preferences, String name, Secret defaultValue) {
        String tempValue = preferences.get(name);
        if (StringTools.isEmpty(tempValue)) {
            return defaultValue;
        }
        return Secret.parse(tempValue);
    }

    public static void importPreferences(IPreferences root, IPreferences source) throws BackingStoreException {
        String[] childrenNames = source.childrenNames();
        for (int i = 0; i < childrenNames.length; ++i) {
            String childName = childrenNames[i];
            IPreferences rootChild = root.node(childName);
            IPreferences sourceChild = source.node(childName);
            PreferencesTools.importPreferences(rootChild, sourceChild);
        }
        String[] keys = source.keys();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            root.put(key, source.get(key));
        }
    }

    public static IArgs mergeArgs(IPreferences source, IArgs args) {
        try {
            String[] childrenNames = source.childrenNames();
            for (int i = 0; i < childrenNames.length; ++i) {
                String childName = childrenNames[i];
                IPreferences sourceChild = source.node(childName);
                if (args.isDefined(childName)) continue;
                if (sourceChild == null) {
                    args.put(childName, null);
                    continue;
                }
                Args tempArgs = Args.create();
                args.put(childName, (Object)tempArgs);
                PreferencesTools.mergeArgs(sourceChild, tempArgs);
            }
            String[] keys = source.keys();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (args.isDefined(key)) continue;
                args.put(key, (Object)source.get(key));
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return args;
    }

    public static void moveIfAbsent(IPreferences newNode, IPreferences oldNode, String name) {
        String newValue = newNode.get(name);
        if (StringTools.isEmpty(newValue)) {
            String oldValue = oldNode.get(name);
            newNode.put(name, oldValue);
            oldNode.remove(name);
        }
    }

    protected static void putArgArgs(IPreferences preferences, String name, IArgs pValue, IArgumentDeclaration argDecl) {
        IPreferences childNode = preferences.node(name);
        IDeclarationBlock argDeclBlock = null;
        if (argDecl instanceof IDeclarationBlock) {
            argDeclBlock = (IDeclarationBlock)((Object)argDecl);
        } else if (argDecl instanceof IDeclarationSupport) {
            argDeclBlock = ((IDeclarationSupport)((Object)argDecl)).getDeclarationBlock();
        }
        IDeclarationElement[] childDeclarations = null;
        if (argDeclBlock != null) {
            childDeclarations = argDeclBlock.getDeclarationElements();
        }
        if (childDeclarations != null) {
            if (childDeclarations.length > 0) {
                PreferencesTools.putArgsDeclared(childNode, pValue, childDeclarations);
            } else if (argDecl.getType() == Object.class || argDecl.getType() == IArgs.class) {
                PreferencesTools.putArgsAll(childNode, pValue);
            }
        } else {
            PreferencesTools.putArgsAll(childNode, pValue);
        }
    }

    protected static void putArgNull(IPreferences preferences, String name) {
    }

    public static void putArgs(IPreferences preferences, IArgs args, IDeclarationBlock block) {
        PreferencesTools.putArgsDeclared(preferences, args, block.getDeclarationElements());
    }

    public static void putArgsAll(IPreferences preferences, IArgs args) {
        Set<String> names = args.names();
        if (names.isEmpty()) {
            for (int i = 0; i < args.size(); ++i) {
                Object value = args.get(i);
                PreferencesTools.putArgValue(preferences, String.valueOf(i), value, null);
            }
        } else {
            for (String argName : names) {
                if (!args.isDefined(argName)) continue;
                Object value = args.get(argName);
                PreferencesTools.putArgValue(preferences, argName, value, null);
            }
        }
    }

    public static void putArgsDeclared(IPreferences preferences, IArgs args, IDeclarationElement[] declarations) {
        for (int i = 0; i < declarations.length; ++i) {
            IArgumentDeclaration argDecl;
            String argName;
            IDeclarationElement decl = declarations[i];
            if (!(decl instanceof IArgumentDeclaration) || !args.isDefined(argName = (argDecl = (IArgumentDeclaration)decl).getName())) continue;
            Object argValue = args.get(argName);
            PreferencesTools.putArgValue(preferences, argName, argValue, argDecl);
        }
    }

    protected static void putArgString(IPreferences preferences, String name, Object pValue) {
        String tempValue = StringTools.safeString(pValue);
        preferences.put(name, tempValue);
    }

    public static void putArgValue(IPreferences preferences, String name, Object pValue, IArgumentDeclaration argDecl) {
        boolean modTransient;
        boolean bl = modTransient = argDecl != null && argDecl.hasModifier("transient");
        if (modTransient) {
            return;
        }
        if ((pValue = PreferencesTools.convertValue(pValue)) == null) {
            PreferencesTools.putArgNull(preferences, name);
        } else if (pValue instanceof IArgs) {
            PreferencesTools.putArgArgs(preferences, name, (IArgs)pValue, argDecl);
        } else if (pValue instanceof InstanceSpec) {
            PreferencesTools.putArgArgs(preferences, name, ((InstanceSpec)pValue).toArgs(), argDecl);
        } else {
            PreferencesTools.putArgString(preferences, name, pValue);
        }
    }

    public static void putEnumItem(IPreferences preferences, String name, EnumItem item) {
        preferences.put(name, item.getId());
    }

    public static void putLarge(IPreferences preferences, String name, String longValue) {
        try {
            String subKey;
            preferences.remove(name);
            IPreferences childNode = preferences.node(name);
            childNode.clear();
            StringReader reader = new StringReader(longValue);
            char[] buffer = new char[8192];
            int i = 0;
            String subValue = null;
            int length = reader.read(buffer);
            while (length != -1) {
                subKey = "part" + i++;
                subValue = new String(buffer, 0, length);
                childNode.put(subKey, subValue);
                length = reader.read(buffer);
            }
            if (subValue != null && subValue.length() == 8192) {
                subKey = "part" + i++;
                subValue = "";
                childNode.put(subKey, subValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void putSecret(IPreferences preferences, String name, Secret value) {
        if (CryptoTools.isEmpty(value)) {
            preferences.remove(name);
        } else {
            String tempValue = value.getEncoded();
            preferences.put(name, tempValue);
        }
    }

    public static void setPreferences(IPreferences preferences, IElement element) {
        Iterator<IElement> key = element.elementIterator("node");
        while (key.hasNext()) {
            IElement childElement = key.next();
            String name = childElement.attributeValue("name", null);
            IPreferences childPreferences = preferences.node(name);
            PreferencesTools.setPreferences(childPreferences, childElement);
        }
        Iterator<IElement> propertyElements = element.elementIterator("property");
        while (propertyElements.hasNext()) {
            IElement propertyElement = propertyElements.next();
            String name = propertyElement.attributeValue("name", null);
            String value = propertyElement.attributeValue("value", null);
            preferences.put(name, value);
        }
    }

    public static String toKeyName(String name) {
        return PreferencesTools.fitLength(name, 80);
    }

    public static String toNodeName(String name) {
        return PreferencesTools.fitLength(name, 80);
    }

    public static Rectangle toRect(String value) {
        if (value == null) {
            return null;
        }
        int[] rectDef = Converter.asIntArray(value);
        if (rectDef == null || rectDef.length < 4) {
            return null;
        }
        return new Rectangle(rectDef[0], rectDef[1], rectDef[2], rectDef[3]);
    }

    public static Rectangle toRect(String value, int[] ranges) {
        if (value == null) {
            return null;
        }
        String[] rectDefs = Converter.asStringArray(value);
        if (rectDefs == null || rectDefs.length != 4) {
            return null;
        }
        int[] rectValues = new int[4];
        for (int i = 0; i < rectDefs.length; ++i) {
            String rectDef = rectDefs[i];
            if (rectDef.indexOf("%") >= 0) {
                rectDef = rectDef.replace("%", "");
                try {
                    rectValues[i] = (int)((float)Converter.asInteger(rectDef) * (float)ranges[i] / 100.0f);
                }
                catch (ConverterException e) {
                    rectValues[i] = 0;
                }
                continue;
            }
            try {
                rectValues[i] = Converter.asInteger(rectDef);
                continue;
            }
            catch (ConverterException e) {
                rectValues[i] = 0;
            }
        }
        return new Rectangle(rectValues[0], rectValues[1], rectValues[2], rectValues[3]);
    }

    public static String toString(float[] value) {
        if (value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                sb.append(ELEMENT_SEPARATOR);
            }
            sb.append(value[i]);
        }
        return sb.toString();
    }

    public static String toString(int[] value) {
        if (value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                sb.append(ELEMENT_SEPARATOR);
            }
            sb.append(value[i]);
        }
        return sb.toString();
    }

    public static String toString(List value) {
        if (value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = value.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            sb.append(String.valueOf(element));
            if (!it.hasNext()) continue;
            sb.append(ELEMENT_SEPARATOR);
        }
        return sb.toString();
    }

    public static String toString(Map map) {
        if (map == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            sb.append(String.valueOf(entry.getKey()));
            sb.append(KEY_VALUE_SEPARATOR);
            String value = entry.getValue() == null ? "" : String.valueOf(entry.getValue());
            sb.append((Object)value);
            if (!i.hasNext()) continue;
            sb.append(ELEMENT_SEPARATOR);
        }
        return sb.toString();
    }

    public static String toString(Rectangle rect) {
        if (rect == null) {
            return "";
        }
        int[] rectDef = new int[]{rect.x, rect.y, rect.width, rect.height};
        return PreferencesTools.toString(rectDef);
    }

    public static String toString(String[] value) {
        if (value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                sb.append(ELEMENT_SEPARATOR);
            }
            sb.append(value[i]);
        }
        return sb.toString();
    }

    public static String[] toStringArray(String value) {
        if (value == null) {
            return null;
        }
        StringTokenizer tk = new StringTokenizer(value, ELEMENT_SEPARATOR, false);
        String[] result = new String[tk.countTokens()];
        int i = 0;
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            result[i] = token.trim();
            ++i;
        }
        return result;
    }

    private PreferencesTools() {
    }

    public static class InstallRoot
    extends Install {
        @PostConstruct
        public void install() {
            IPreferences preferences = PreferencesFactory.get().getRoot();
            PreferencesTools.setPreferences(preferences, this.getElement());
        }
    }

    public static class InstallNode
    extends Install {
        private String name;

        public String getName() {
            return this.name;
        }

        @PostConstruct
        public void install() {
            IPreferences root = PreferencesFactory.get().getRoot();
            IPreferences preferences = root.node(this.getName());
            if (preferences != null) {
                PreferencesTools.setPreferences(preferences, this.getElement());
            }
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class InstallMain
    extends Install {
        @PostConstruct
        public void install() {
            IPreferences preferences = PreferencesFactory.get().getMain();
            PreferencesTools.setPreferences(preferences, this.getElement());
        }
    }

    public static abstract class Install
    implements IElementConfigurable {
        private IElement element;

        @Override
        public void configure(IElement element) throws ConfigurationException {
            this.element = element;
        }

        public IElement getElement() {
            return this.element;
        }
    }
}

