/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.preferences;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IScopedPlatformPreferences;
import de.intarsys.tools.preferences.PreferencesChangeEvent;
import de.intarsys.tools.preferences.PreferencesTools;
import de.intarsys.tools.reflect.FieldAccessException;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.IBasicAccessSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesAdapter
implements IPreferences,
INotificationSupport,
PreferenceChangeListener,
IBasicAccessSupport {
    private static final Logger Log = LoggerFactory.getLogger(PreferencesAdapter.class);
    public static final String NODE_METADATA = "__metadata";
    public static final String MODIFIER_NULL = "null";
    private final Map<String, PreferencesAdapter> children = new HashMap<String, PreferencesAdapter>();
    private final Preferences jPrefs;
    private final PreferencesAdapter parent;
    private EventDispatcher dispatcher;
    private final Object lock = new Object();
    private final PreferencesAdapter root;

    public PreferencesAdapter(PreferencesAdapter parent, Preferences jPrefs) {
        this.parent = parent;
        this.jPrefs = jPrefs;
        this.root = parent != null ? parent.root : this;
    }

    @Override
    public String absolutePath() {
        return this.getJPrefs().absolutePath();
    }

    public synchronized void addNotificationListener(EventType type, INotificationListener listener) {
        if (this.dispatcher == null) {
            this.dispatcher = new EventDispatcher(this);
            this.getJPrefs().addPreferenceChangeListener(this);
        }
        this.dispatcher.addNotificationListener(type, listener);
    }

    @Override
    public Object basicGetValue(String name) throws FieldException {
        try {
            if (this.nodeExists(name)) {
                return this.node(name);
            }
        }
        catch (BackingStoreException e) {
            throw new FieldAccessException(this.getClass(), name);
        }
        return this.get(name);
    }

    @Override
    public Object basicSetValue(String name, Object value) throws FieldException {
        String oldValue = this.get(name);
        if (value == null) {
            this.remove(name);
        } else {
            String stringValue;
            try {
                stringValue = ConverterRegistry.get().convert(value, String.class);
            }
            catch (ConversionException e) {
                stringValue = String.valueOf(value);
            }
            this.put(name, stringValue);
        }
        return oldValue;
    }

    @Override
    public IPreferences[] children() {
        ArrayList<IPreferences> result = new ArrayList<IPreferences>();
        String[] names = this.childrenNames();
        for (int i = 0; i < names.length; ++i) {
            result.add(this.node(names[i]));
        }
        return result.toArray(new IPreferences[result.size()]);
    }

    @Override
    public String[] childrenNames() {
        try {
            String[] basicNames = this.getJPrefs().childrenNames();
            ArrayList<String> result = new ArrayList<String>();
            for (String name : basicNames) {
                if (NODE_METADATA.equals(name)) continue;
                result.add(name);
            }
            return result.toArray(new String[result.size()]);
        }
        catch (BackingStoreException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return new String[0];
        }
    }

    @Override
    public void clear() throws BackingStoreException {
        this.getJPrefs().clear();
    }

    protected PreferencesAdapter createPreferencesNode(String name) {
        return new PreferencesAdapter(this, this.getJPrefs().node(PreferencesTools.toKeyName(name)));
    }

    @Override
    public void flush() {
        try {
            this.getJPrefs().flush();
        }
        catch (BackingStoreException e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String get(String name) {
        if (this.hasModifier(name, MODIFIER_NULL)) {
            return null;
        }
        return this.getJPrefs().get(PreferencesTools.toKeyName(name), null);
    }

    @Override
    public String get(String name, String def) {
        if (this.hasModifier(name, MODIFIER_NULL)) {
            return def;
        }
        return this.getJPrefs().get(PreferencesTools.toKeyName(name), def);
    }

    @Override
    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    @Override
    public boolean getBoolean(String name, boolean def) {
        if (this.hasModifier(name, MODIFIER_NULL)) {
            return def;
        }
        return this.getJPrefs().getBoolean(PreferencesTools.toKeyName(name), def);
    }

    @Override
    public byte[] getByteArray(String name, byte[] def) {
        if (this.hasModifier(name, MODIFIER_NULL)) {
            return def;
        }
        return this.getJPrefs().getByteArray(PreferencesTools.toKeyName(name), def);
    }

    @Override
    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    @Override
    public double getDouble(String name, double def) {
        if (this.hasModifier(name, MODIFIER_NULL)) {
            return def;
        }
        return this.getJPrefs().getDouble(PreferencesTools.toKeyName(name), def);
    }

    @Override
    public float getFloat(String name) {
        return this.getFloat(name, 0.0f);
    }

    @Override
    public float getFloat(String name, float def) {
        if (this.hasModifier(name, MODIFIER_NULL)) {
            return def;
        }
        return this.getJPrefs().getFloat(PreferencesTools.toKeyName(name), def);
    }

    @Override
    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    @Override
    public int getInt(String name, int def) {
        if (this.hasModifier(name, MODIFIER_NULL)) {
            return def;
        }
        return this.getJPrefs().getInt(PreferencesTools.toKeyName(name), def);
    }

    protected Preferences getJPrefs() {
        return this.jPrefs;
    }

    @Override
    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    @Override
    public long getLong(String name, long def) {
        if (this.hasModifier(name, MODIFIER_NULL)) {
            return def;
        }
        return this.getJPrefs().getLong(PreferencesTools.toKeyName(name), def);
    }

    protected Preferences getMetadata() {
        return this.getJPrefs().node(NODE_METADATA);
    }

    @Override
    public String getModifierString(String name) {
        return this.getMetadata().get(PreferencesTools.toKeyName(name), null);
    }

    @Override
    public boolean hasModifier(String key, String modifier) {
        String modifierString = this.getModifierString(key);
        if (modifierString == null) {
            return false;
        }
        return modifierString.indexOf(modifier) >= 0;
    }

    @Override
    public String[] keys() {
        try {
            return this.getJPrefs().keys();
        }
        catch (BackingStoreException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return new String[0];
        }
    }

    @Override
    public String name() {
        return this.getJPrefs().name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized IPreferences node(String pathName) {
        Object object = this.lock;
        synchronized (object) {
            if ("".equals(pathName)) {
                return this;
            }
            if (pathName.equals("/")) {
                return this.root;
            }
            if (!pathName.startsWith("/")) {
                return this.node(new StringTokenizer(pathName, "/", true));
            }
        }
        return this.root.node(new StringTokenizer(pathName.substring(1), "/", true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IPreferences node(StringTokenizer path) {
        String token = path.nextToken();
        if (token.equals("/")) {
            throw new IllegalArgumentException("Consecutive slashes in path");
        }
        if (this.hasModifier(token, MODIFIER_NULL)) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            PreferencesAdapter child = this.children.computeIfAbsent(token, key -> this.createPreferencesNode(token));
            if (!path.hasMoreTokens()) {
                return child;
            }
            path.nextToken();
            if (!path.hasMoreTokens()) {
                throw new IllegalArgumentException("Path ends with slash");
            }
            return child.node(path);
        }
    }

    @Override
    public boolean nodeExists(String path) throws BackingStoreException {
        return this.getJPrefs().nodeExists(path);
    }

    @Override
    public IPreferences parent() {
        return this.parent;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        this.triggerChange(evt);
    }

    @Override
    public Map<String, String> properties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        String[] keys = this.keys();
        for (int i = 0; i < keys.length; ++i) {
            properties.put(keys[i], this.get(keys[i]));
        }
        return properties;
    }

    @Override
    public void put(String name, boolean value) {
        this.getJPrefs().putBoolean(PreferencesTools.toKeyName(name), value);
    }

    @Override
    public void put(String name, byte[] value) {
        if (value == null) {
            this.getJPrefs().remove(PreferencesTools.toKeyName(name));
        } else {
            this.getJPrefs().putByteArray(PreferencesTools.toKeyName(name), value);
        }
    }

    @Override
    public void put(String name, double value) {
        this.getJPrefs().putDouble(PreferencesTools.toKeyName(name), value);
    }

    @Override
    public void put(String name, float value) {
        this.getJPrefs().putFloat(PreferencesTools.toKeyName(name), value);
    }

    @Override
    public void put(String name, int value) {
        this.getJPrefs().putInt(PreferencesTools.toKeyName(name), value);
    }

    @Override
    public void put(String name, long value) {
        this.getJPrefs().putLong(PreferencesTools.toKeyName(name), value);
    }

    @Override
    public void put(String name, String value) {
        if (value == null) {
            this.getJPrefs().remove(PreferencesTools.toKeyName(name));
        } else {
            this.getJPrefs().put(PreferencesTools.toKeyName(name), value);
        }
    }

    @Override
    public void putBoolean(String name, boolean value) {
        this.getJPrefs().putBoolean(PreferencesTools.toKeyName(name), value);
    }

    @Override
    public void putByteArray(String name, byte[] value) {
        if (value == null) {
            this.getJPrefs().remove(PreferencesTools.toKeyName(name));
        } else {
            this.getJPrefs().putByteArray(PreferencesTools.toKeyName(name), value);
        }
    }

    @Override
    public void putDouble(String name, double value) {
        this.getJPrefs().putDouble(PreferencesTools.toKeyName(name), value);
    }

    @Override
    public void putFloat(String name, float value) {
        this.getJPrefs().putFloat(PreferencesTools.toKeyName(name), value);
    }

    @Override
    public void putInt(String name, int value) {
        this.getJPrefs().putInt(PreferencesTools.toKeyName(name), value);
    }

    @Override
    public void putLong(String name, long value) {
        this.getJPrefs().putLong(PreferencesTools.toKeyName(name), value);
    }

    @Override
    public void remove(String name) {
        this.getJPrefs().remove(PreferencesTools.toKeyName(name));
        this.removeModifiers(name);
    }

    public void removeModifiers(String name) {
        this.getMetadata().remove(PreferencesTools.toKeyName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNode() throws BackingStoreException {
        if (this.parent == null) {
            throw new UnsupportedOperationException("Can't remove the root!");
        }
        Object object = this.parent.lock;
        synchronized (object) {
            this.getJPrefs().removeNode();
            this.parent.children.remove(this.getJPrefs().name());
        }
    }

    public synchronized void removeNotificationListener(EventType type, INotificationListener listener) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.removeNotificationListener(type, listener);
        if (this.dispatcher.isEmpty()) {
            this.getJPrefs().removePreferenceChangeListener(this);
        }
    }

    @Override
    public IPreferences restrict(String scopeName) {
        if (this.getJPrefs() instanceof IScopedPlatformPreferences) {
            return new PreferencesAdapter(null, ((IScopedPlatformPreferences)((Object)this.getJPrefs())).restrict(scopeName));
        }
        return this;
    }

    @Override
    public void setModifierString(String key, String modifiers) {
        if (modifiers == null) {
            this.getMetadata().remove(key);
        } else {
            this.getMetadata().put(key, modifiers);
        }
    }

    @Override
    public void sync() throws BackingStoreException {
        this.getJPrefs().sync();
    }

    protected void triggerChange(PreferenceChangeEvent jEvent) {
        PreferencesChangeEvent event = new PreferencesChangeEvent(this);
        event.setKey(jEvent.getKey());
        event.setNewValue(jEvent.getNewValue());
        this.triggerEvent(event);
    }

    protected void triggerEvent(Event event) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.triggerEvent(event);
    }
}

