/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.oid;

import de.intarsys.tools.oid.CommonOIDGenerator;
import java.util.Random;

public class PronouncableOIDGenerator
extends CommonOIDGenerator<String> {
    private static char[] Vowels = "aeiou".toCharArray();
    private static char[] Consonants = "bcdfghjklmnprstvwxyz".toCharArray();
    private int length = 8;
    private final Random random = new Random();
    private char[] pattern = "cv".toCharArray();

    public PronouncableOIDGenerator() {
    }

    public PronouncableOIDGenerator(String pattern) {
        this.setPattern(pattern.toCharArray());
        this.setLength(pattern.length());
    }

    public PronouncableOIDGenerator(String pattern, int length) {
        this.setPattern(pattern.toCharArray());
        this.setLength(length);
    }

    @Override
    public String createOID() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.length; ++i) {
            int index = i % this.pattern.length;
            char type = this.pattern[index];
            sb.append(switch (type) {
                case 'c' -> Consonants[this.random.nextInt(Consonants.length)];
                case 'v' -> Vowels[this.random.nextInt(Vowels.length)];
                default -> throw new IllegalArgumentException("unknown pattern selector " + type);
            });
        }
        return sb.toString();
    }

    public int getLength() {
        return this.length;
    }

    public char[] getPattern() {
        return this.pattern;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setPattern(char[] pattern) {
        this.pattern = pattern;
    }
}

