/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.objectmodel;

import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.objectmodel.Class;
import de.intarsys.tools.objectmodel.ClassRegistry;
import de.intarsys.tools.objectmodel.IClass;
import de.intarsys.tools.objectmodel.IClassSelector;
import de.intarsys.tools.objectmodel.IField;
import de.intarsys.tools.objectmodel.IMethod;
import de.intarsys.tools.objectmodel.InvokeAccept;
import de.intarsys.tools.objectmodel.InvokeIntercept;
import de.intarsys.tools.objectmodel.JavaClassSelector;
import de.intarsys.tools.objectmodel.JavaInstanceSelector;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.FieldNotFoundException;
import de.intarsys.tools.reflect.MethodException;
import de.intarsys.tools.reflect.MethodNotFoundException;
import de.intarsys.tools.reflect.ObjectCreationException;

public class ObjectModelTools {
    public static IClassSelector createSelector(String value) throws ObjectCreationException {
        String[] fragments = value.split(":");
        java.lang.Class<Object> clazz = ClassTools.createClass(fragments[0], Object.class, null);
        if (fragments.length > 1) {
            return new JavaInstanceSelector(clazz, fragments[1]);
        }
        return new JavaClassSelector(clazz);
    }

    public static Object get(Object receiver, Object id, String name) throws FieldException {
        if (receiver == null) {
            throw new NullPointerException("can not call '" + name + "' for 'null'");
        }
        IField field = ObjectModelTools.lookupField(receiver.getClass(), id, name);
        return field.getValue(receiver);
    }

    public static Object get(Object receiver, String name) throws FieldException {
        if (receiver == null) {
            throw new NullPointerException("can not call '" + name + "' for 'null'");
        }
        IField field = ObjectModelTools.lookupField(receiver.getClass(), name);
        return field.getValue(receiver);
    }

    public static Object invoke(Object receiver, Object id, String name, IArgs args) throws MethodException {
        if (receiver == null) {
            throw new NullPointerException("can't call '" + name + "' for 'null'");
        }
        IMethod method = ObjectModelTools.lookupMethod(receiver.getClass(), id, name);
        return method.invoke(receiver, args);
    }

    public static Object invoke(Object receiver, String name, IArgs args) throws MethodException {
        if (receiver == null) {
            throw new NullPointerException("can't call '" + name + "' for 'null'");
        }
        IMethod method = ObjectModelTools.lookupMethod(receiver.getClass(), name);
        return method.invoke(receiver, args);
    }

    protected static Object invokeIntercept(Object receiver, INotificationListener dispatcher, IMethod method, IArgs args) throws MethodException {
        InvokeIntercept intercept = new InvokeIntercept(receiver, dispatcher, method, args);
        dispatcher.handleEvent(intercept);
        if (intercept.isVetoed()) {
            return intercept.getResult();
        }
        return ObjectModelTools.invokeInterceptResume(receiver, dispatcher, method, args);
    }

    public static Object invokeIntercept(Object receiver, INotificationListener dispatcher, String name, IArgs args) throws MethodException {
        if (receiver == null) {
            throw new NullPointerException("can't call '" + name + "' for 'null'");
        }
        IMethod method = ObjectModelTools.lookupMethod(receiver.getClass(), name);
        return ObjectModelTools.invokeIntercept(receiver, dispatcher, method, args);
    }

    public static Object invokeIntercept(Object receiver, Object id, INotificationListener dispatcher, String name, IArgs args) throws MethodException {
        if (receiver == null) {
            throw new NullPointerException("can't call '" + name + "' for 'null'");
        }
        IMethod method = ObjectModelTools.lookupMethod(receiver.getClass(), id, name);
        return ObjectModelTools.invokeIntercept(receiver, dispatcher, method, args);
    }

    protected static Object invokeInterceptResume(Object receiver, INotificationListener dispatcher, IMethod method, IArgs args) throws MethodException {
        Object result = method.invoke(receiver, args);
        InvokeAccept accept = new InvokeAccept(method, receiver, args);
        accept.setResult(result);
        dispatcher.handleEvent(accept);
        return accept.getResult();
    }

    public static IClass lookupClass(IClassSelector selector) {
        IClass clazz = ClassRegistry.get().lookupClass(selector);
        if (clazz == null) {
            clazz = new Class(selector);
            ClassRegistry.get().registerClass(selector, clazz);
        }
        return clazz;
    }

    public static IClass lookupClass(java.lang.Class<?> clazz) {
        JavaClassSelector selector = new JavaClassSelector(clazz);
        return ObjectModelTools.lookupClass(selector);
    }

    public static IClass lookupClass(java.lang.Class<?> clazz, Object id) {
        JavaInstanceSelector selector = new JavaInstanceSelector(clazz, id);
        return ObjectModelTools.lookupClass(selector);
    }

    public static IField lookupField(java.lang.Class<?> clazz, Object id, String name) throws FieldNotFoundException {
        JavaInstanceSelector selector = new JavaInstanceSelector(clazz, id);
        IField result = null;
        IClass extension = ClassRegistry.get().lookupClass(selector);
        if (extension != null && (result = extension.lookupField(name)) != null) {
            return result;
        }
        java.lang.Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            try {
                result = ObjectModelTools.lookupField(superClass, id, name);
                if (result != null) {
                    return result;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        java.lang.Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            try {
                result = ObjectModelTools.lookupField(interfaces[i], id, name);
                if (result == null) continue;
                return result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ObjectModelTools.lookupField(clazz, name);
    }

    public static IField lookupField(java.lang.Class<?> clazz, String name) throws FieldNotFoundException {
        JavaClassSelector selector = new JavaClassSelector(clazz);
        IField result = null;
        IClass extension = ClassRegistry.get().lookupClass(selector);
        if (extension != null && (result = extension.lookupField(name)) != null) {
            return result;
        }
        java.lang.Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            try {
                result = ObjectModelTools.lookupField(superClass, name);
                if (result != null) {
                    return result;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        java.lang.Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            try {
                result = ObjectModelTools.lookupField(interfaces[i], name);
                if (result == null) continue;
                return result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new FieldNotFoundException(clazz, name);
    }

    public static IMethod lookupMethod(java.lang.Class<?> clazz, Object id, String name) throws MethodNotFoundException {
        JavaInstanceSelector selector = new JavaInstanceSelector(clazz, id);
        IMethod result = null;
        IClass extension = ClassRegistry.get().lookupClass(selector);
        if (extension != null && (result = extension.lookupMethod(name)) != null) {
            return result;
        }
        java.lang.Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            try {
                result = ObjectModelTools.lookupMethod(superClass, id, name);
                if (result != null) {
                    return result;
                }
            }
            catch (MethodNotFoundException methodNotFoundException) {
                // empty catch block
            }
        }
        java.lang.Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            try {
                result = ObjectModelTools.lookupMethod(interfaces[i], id, name);
                if (result == null) continue;
                return result;
            }
            catch (MethodNotFoundException methodNotFoundException) {
                // empty catch block
            }
        }
        return ObjectModelTools.lookupMethod(clazz, name);
    }

    public static IMethod lookupMethod(java.lang.Class<?> clazz, String name) throws MethodNotFoundException {
        JavaClassSelector selector = new JavaClassSelector(clazz);
        IMethod result = null;
        IClass extension = ClassRegistry.get().lookupClass(selector);
        if (extension != null && (result = extension.lookupMethod(name)) != null) {
            return result;
        }
        java.lang.Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            try {
                result = ObjectModelTools.lookupMethod(superClass, name);
                if (result != null) {
                    return result;
                }
            }
            catch (MethodNotFoundException methodNotFoundException) {
                // empty catch block
            }
        }
        java.lang.Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            try {
                result = ObjectModelTools.lookupMethod(interfaces[i], name);
                if (result == null) continue;
                return result;
            }
            catch (MethodNotFoundException methodNotFoundException) {
                // empty catch block
            }
        }
        throw new MethodNotFoundException(clazz, name);
    }

    public static IClass registerClass(IClassSelector selector) {
        IClass clazz = ClassRegistry.get().lookupClass(selector);
        if (clazz == null) {
            clazz = new Class(selector);
            ClassRegistry.get().registerClass(selector, clazz);
        }
        return clazz;
    }

    public static IClass registerClass(IClassSelector selector, IClass clazz) {
        ClassRegistry.get().registerClass(selector, clazz);
        return clazz;
    }

    public static IClass registerClass(java.lang.Class<?> clazz) {
        JavaClassSelector selector = new JavaClassSelector(clazz);
        return ObjectModelTools.registerClass(selector);
    }

    public static IClass registerClass(java.lang.Class<?> clazz, Object id) {
        JavaInstanceSelector selector = new JavaInstanceSelector(clazz, id);
        return ObjectModelTools.registerClass(selector);
    }

    public static void registerField(IClassSelector selector, IField field) {
        IClass clazz = ClassRegistry.get().lookupClass(selector);
        if (clazz == null) {
            clazz = new Class(selector);
            ClassRegistry.get().registerClass(clazz.getSelector(), clazz);
        }
        ((Class)clazz).registerField(field);
    }

    public static void registerField(java.lang.Class<?> clazz, IField field) {
        JavaClassSelector selector = new JavaClassSelector(clazz);
        ObjectModelTools.registerField(selector, field);
    }

    public static void registerField(java.lang.Class<?> clazz, Object id, IField field) {
        JavaInstanceSelector selector = new JavaInstanceSelector(clazz, id);
        ObjectModelTools.registerField(selector, field);
    }

    public static void registerMethod(IClassSelector selector, IMethod method) {
        IClass clazz = ClassRegistry.get().lookupClass(selector);
        if (clazz == null) {
            clazz = new Class(selector);
            ClassRegistry.get().registerClass(clazz.getSelector(), clazz);
        }
        ((Class)clazz).registerMethod(method);
    }

    public static void registerMethod(java.lang.Class<?> clazz, IMethod method) {
        JavaClassSelector selector = new JavaClassSelector(clazz);
        ObjectModelTools.registerMethod(selector, method);
    }

    public static void registerMethod(java.lang.Class<?> clazz, Object id, IMethod method) {
        JavaInstanceSelector selector = new JavaInstanceSelector(clazz, id);
        ObjectModelTools.registerMethod(selector, method);
    }

    public static void set(Object receiver, Object id, String name, Object value) throws FieldException {
        if (receiver == null) {
            throw new NullPointerException("can not call '" + name + "' for 'null'");
        }
        IField field = ObjectModelTools.lookupField(receiver.getClass(), id, name);
        field.setValue(receiver, value);
    }

    public static void set(Object receiver, String name, Object value) throws FieldException {
        if (receiver == null) {
            throw new NullPointerException("can not call '" + name + "' for 'null'");
        }
        IField field = ObjectModelTools.lookupField(receiver.getClass(), name);
        field.setValue(receiver, value);
    }

    private ObjectModelTools() {
    }
}

