/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.format.TrivialIntegerFormat;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.monitor.AbstractMonitor;
import de.intarsys.tools.monitor.ITrace;
import de.intarsys.tools.monitor.MonitorStatistic;
import de.intarsys.tools.monitor.MonitorTrace;
import de.intarsys.tools.string.StringTools;
import java.io.StringWriter;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class Monitor
extends AbstractMonitor {
    protected static final String TXT_VER_SEPARATOR = " | ";
    protected static final String TXT_HOR_SEPARATOR = "------------------------------------------------------------------------";
    protected static final int COLWIDTH_LABEL = 80;
    protected static final int COLWIDTH_NUMBER = 7;
    private static final Format DEFAULT_FORMAT = TrivialIntegerFormat.getInstance();
    public static final String ATTR_NAME = "name";
    public static final String ATTR_MAX = "max";
    public static final String ATTR_MIN = "min";
    public static final String ATTR_COUNT = "count";
    public static final String ATTR_TOTAL = "total";
    public static final String ATTR_EFFECTIVE = "effective";
    public static final String ATTR_AVG = "avg";
    public static final String ATTR_FIRST = "first";
    public static final String ATTR_LAST = "last";
    private boolean relative = true;
    protected volatile long first;
    protected volatile long last;
    protected MonitorStatistic statistic = new MonitorStatistic("stop", Integer.MAX_VALUE);
    protected Map sampleStatistics = new HashMap();

    protected Monitor() {
    }

    protected Monitor(String name) {
        super(name);
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        if (ElementTools.getPathBoolean(element, "deltasamples", true)) {
            this.setRelative(true);
        }
    }

    protected abstract void doCalculation(MonitorTrace var1);

    @Override
    public synchronized Map getData() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(ATTR_NAME, this.getName());
        attributes.put(ATTR_FIRST, this.first);
        attributes.put(ATTR_LAST, this.last);
        attributes.put(ATTR_MIN, this.statistic.min);
        attributes.put(ATTR_MAX, this.statistic.max);
        attributes.put(ATTR_COUNT, this.statistic.count);
        attributes.put(ATTR_EFFECTIVE, this.statistic.total);
        attributes.put(ATTR_AVG, this.statistic.avg);
        return attributes;
    }

    protected Format getFormat() {
        return DEFAULT_FORMAT;
    }

    @Override
    public synchronized Map getFormattedData() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(ATTR_NAME, this.getName());
        attributes.put(ATTR_FIRST, this.getFormat().format(this.first));
        attributes.put(ATTR_LAST, this.getFormat().format(this.last));
        attributes.put(ATTR_MIN, this.statistic.min);
        attributes.put(ATTR_MAX, this.statistic.max);
        attributes.put(ATTR_COUNT, this.statistic.count);
        attributes.put(ATTR_EFFECTIVE, this.statistic.total);
        attributes.put(ATTR_AVG, this.statistic.avg);
        return attributes;
    }

    public boolean isRelative() {
        return this.relative;
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.first = -1L;
        this.last = -1L;
        this.statistic.reset();
        this.sampleStatistics = new HashMap();
    }

    public void setRelative(boolean relative) {
        this.relative = relative;
    }

    @Override
    protected synchronized void started(ITrace trace) {
        if (this.first == -1L) {
            this.first = ((MonitorTrace)trace).getStart();
        }
    }

    @Override
    protected synchronized void stopped(ITrace trace) {
        this.last = ((MonitorTrace)trace).getStop();
        this.doCalculation((MonitorTrace)trace);
        super.stopped(trace);
    }

    protected String toFormattedString(String value, int length) {
        if (value == null) {
            value = "";
        }
        if (value.length() > length) {
            return value.substring(0, length);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(value);
        for (int i = value.length(); i < length; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public String toString() {
        return this.toTableString();
    }

    public String toTableString() {
        StringWriter sw = new StringWriter();
        sw.write(StringTools.LS);
        sw.write("   ");
        sw.write(this.getName());
        sw.write(StringTools.LS);
        sw.write(StringTools.LS);
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString("description", 80));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(ATTR_COUNT, 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(ATTR_TOTAL, 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString("total %", 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(ATTR_MIN, 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(ATTR_MAX, 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(ATTR_AVG, 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(StringTools.LS);
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(TXT_HOR_SEPARATOR, 80));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(StringTools.LS);
        ArrayList sampleStatisticList = new ArrayList(this.sampleStatistics.values());
        Collections.sort(sampleStatisticList);
        for (MonitorStatistic sampleStatistic : sampleStatisticList) {
            sw.write(TXT_VER_SEPARATOR);
            sw.write(this.toFormattedString(sampleStatistic.description, 80));
            sw.write(TXT_VER_SEPARATOR);
            sw.write(this.toFormattedString(String.valueOf(sampleStatistic.count), 7));
            sw.write(TXT_VER_SEPARATOR);
            sw.write(this.toFormattedString(String.valueOf(sampleStatistic.total), 7));
            sw.write(TXT_VER_SEPARATOR);
            float totalPercent = (float)Math.round((float)sampleStatistic.total / (float)this.statistic.total * 10000.0f) / 100.0f;
            sw.write(this.toFormattedString(String.valueOf(totalPercent), 7));
            sw.write(TXT_VER_SEPARATOR);
            sw.write(this.toFormattedString(String.valueOf(sampleStatistic.min), 7));
            sw.write(TXT_VER_SEPARATOR);
            sw.write(this.toFormattedString(String.valueOf(sampleStatistic.max), 7));
            sw.write(TXT_VER_SEPARATOR);
            sw.write(this.toFormattedString(String.valueOf(sampleStatistic.avg), 7));
            sw.write(TXT_VER_SEPARATOR);
            sw.write(StringTools.LS);
        }
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(TXT_HOR_SEPARATOR, 80));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(StringTools.LS);
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString("", 80));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(String.valueOf(this.statistic.count), 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(String.valueOf(this.statistic.total), 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(String.valueOf(100), 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(String.valueOf(this.statistic.min), 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(String.valueOf(this.statistic.max), 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(this.toFormattedString(String.valueOf(this.statistic.avg), 7));
        sw.write(TXT_VER_SEPARATOR);
        sw.write(StringTools.LS);
        return sw.toString();
    }
}

