/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.monitor.AbstractMonitor;
import de.intarsys.tools.monitor.CompositeMonitorTrace;
import de.intarsys.tools.monitor.IMonitor;
import de.intarsys.tools.monitor.ITrace;
import de.intarsys.tools.monitor.MonitorFactory;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CompositeMonitor
extends AbstractMonitor {
    private List<IMonitor> children = new ArrayList<IMonitor>();

    public CompositeMonitor() {
    }

    public CompositeMonitor(String name) {
        super(name);
    }

    public void addMonitor(IMonitor monitor) {
        this.children.add(monitor);
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        try {
            this.children = MonitorFactory.createChildMonitors(element, null);
        }
        catch (ObjectCreationException e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    protected CompositeMonitorTrace createMonitorTrace() {
        ITrace[] traces = new ITrace[this.getChildren().size()];
        int i = 0;
        for (IMonitor monitor : this.children) {
            traces[i] = monitor.getCurrentTrace();
            ++i;
        }
        CompositeMonitorTrace trace = new CompositeMonitorTrace(this, traces);
        return trace;
    }

    public List<IMonitor> getChildren() {
        return this.children;
    }

    @Override
    public Map getData() {
        HashMap result = new HashMap();
        for (IMonitor monitor : this.children) {
            Map childData = monitor.getData();
            for (Map.Entry entry : childData.entrySet()) {
                result.put((CallSite)((Object)(monitor.getName() + "." + entry.getKey())), entry.getValue());
            }
        }
        return result;
    }

    @Override
    public Map getFormattedData() {
        HashMap result = new HashMap();
        for (IMonitor monitor : this.children) {
            Map childData = monitor.getFormattedData();
            for (Map.Entry entry : childData.entrySet()) {
                result.put((CallSite)((Object)(monitor.getName() + "." + entry.getKey())), entry.getValue());
            }
        }
        return result;
    }

    @Override
    public void reset() {
        super.reset();
        for (IMonitor monitor : this.children) {
            monitor.reset();
        }
    }

    public String toString() {
        return "Composite Monitor " + this.getName();
    }
}

