/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.message;

import de.intarsys.tools.message.BasicMessageBundle;
import de.intarsys.tools.message.CommonMessageBundle;
import de.intarsys.tools.message.CommonMessageBundleFactory;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.nls.NlsContext;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class NlsContextMessageBundle
extends CommonMessageBundle {
    private final Map<Locale, IMessageBundle> messageBundles = new ConcurrentHashMap<Locale, IMessageBundle>();

    public NlsContextMessageBundle(CommonMessageBundleFactory factory, String name, ClassLoader classLoader) {
        super(factory, name, classLoader);
    }

    @Override
    public Set<String> getCodes() {
        return this.getMessageBundleForLocale().getCodes();
    }

    protected IMessageBundle getMessageBundleForLocale() {
        Locale locale = NlsContext.get().getLocale();
        return this.messageBundles.computeIfAbsent(locale, l -> new BasicMessageBundle(this.getFactory(), this.getName(), (Locale)l, this.getClassLoader()));
    }

    @Override
    public String getPattern(String code) {
        return this.getMessageBundleForLocale().getPattern(code);
    }

    @Override
    public String getString(String code, Object ... args) {
        return this.getMessageBundleForLocale().getString(code, args);
    }
}

