/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.message;

import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.StringEvaluatorTools;
import de.intarsys.tools.message.AliasMessage;
import de.intarsys.tools.message.CompositeMessageBundleFactory;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.IMessageBundleFactory;
import de.intarsys.tools.message.LiteralMessage;
import de.intarsys.tools.message.MessageBundleFactory;
import de.intarsys.tools.reflect.ClassLoaderTools;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.string.StringTools;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Arrays;

public final class MessageTools {
    public static final String MSG = "messages";

    public static IMessageBundleFactory combineFactory(IMessageBundleFactory factory, IMessageBundleFactory newFactory) {
        CompositeMessageBundleFactory compositeFactory;
        if (factory == null) {
            return newFactory;
        }
        if (factory instanceof CompositeMessageBundleFactory) {
            compositeFactory = (CompositeMessageBundleFactory)factory;
        } else {
            compositeFactory = new CompositeMessageBundleFactory();
            compositeFactory.addFactory(factory);
        }
        compositeFactory.addFactory(newFactory);
        return compositeFactory;
    }

    protected static ClassLoader createClassLoader(String classpath) {
        if (StringTools.isEmpty(classpath)) {
            return Thread.currentThread().getContextClassLoader();
        }
        URL[] urls = ClassLoaderTools.parseURLs(classpath);
        if (urls == null || urls.length == 0) {
            return Thread.currentThread().getContextClassLoader();
        }
        return new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
    }

    public static IMessage createMessage(String code, IMessage message, Object ... args) {
        return new AliasMessage(code, message, args);
    }

    public static IMessage createMessage(String code, String value, Object ... args) {
        return LiteralMessage.create(code, value, args);
    }

    public static String format(String pattern, Object ... objects) {
        try {
            return MessageFormat.format(pattern, objects);
        }
        catch (Exception e) {
            return "[" + pattern + "]";
        }
    }

    public static String getBundleName(Class clazz) {
        return MessageTools.getBundleName(clazz, MSG);
    }

    public static String getBundleName(Class clazz, String suffix) {
        return ClassTools.getPackageName(clazz) + "." + suffix;
    }

    public static String getBundleName(String className) {
        return ClassTools.getPackageName(className) + ".messages";
    }

    public static IMessage getMessage(Object object, String code, Object ... args) {
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        return MessageTools.getMessageBundle(clazz).getMessage(ClassTools.getUnqualifiedName(clazz) + "." + code, args);
    }

    public static IMessageBundle getMessageBundle(Class clazz) {
        return MessageBundleFactory.get().getMessageBundle(MessageTools.getBundleName(clazz), clazz.getClassLoader());
    }

    public static IMessageBundle getMessageBundle(String name, ClassLoader classloader) {
        return MessageBundleFactory.get().getMessageBundle(name, classloader);
    }

    public static IMessageBundle getMessageBundle(String name, String classpath) {
        ClassLoader classLoader = MessageTools.createClassLoader(classpath);
        return MessageTools.getMessageBundle(name, classLoader);
    }

    public static Object toObjectExpanded(IStringEvaluator evaluator, Object message) {
        return MessageTools.toObjectExpandedRecurse(evaluator, message, 4);
    }

    public static Object toObjectExpandedRecurse(IStringEvaluator evaluator, Object message, int maxDepth) {
        if (message == null) {
            return null;
        }
        Object tmpMessage = null;
        tmpMessage = message instanceof IMessage ? ((IMessage)message).getString() : message;
        Object result = StringEvaluatorTools.evaluate(evaluator, tmpMessage);
        if (result instanceof IMessage && maxDepth > 0) {
            return MessageTools.toSafeStringExpandedRecurse(evaluator, result, maxDepth - 1);
        }
        return result;
    }

    public static String toSafeString(Object message) {
        if (message instanceof IMessage) {
            return ((IMessage)message).getString();
        }
        return StringTools.safeString(message);
    }

    public static String toSafeStringExpanded(IStringEvaluator evaluator, Object message) {
        return MessageTools.toSafeStringExpandedRecurse(evaluator, message, 4);
    }

    public static String toSafeStringExpandedRecurse(IStringEvaluator evaluator, Object message, int maxDepth) {
        Object result = MessageTools.toObjectExpandedRecurse(evaluator, message, maxDepth);
        if (result instanceof IMessage && maxDepth > 0) {
            return MessageTools.toSafeStringExpandedRecurse(evaluator, result, maxDepth - 1);
        }
        return StringTools.safeString(result);
    }

    public static String toString(Object message) {
        if (message == null) {
            return null;
        }
        return MessageTools.toSafeString(message);
    }

    public static String toStringExpanded(IStringEvaluator evaluator, Object message) {
        if (message == null) {
            return null;
        }
        return MessageTools.toSafeStringExpanded(evaluator, message);
    }

    public static String toStringExpandedRecurse(IStringEvaluator evaluator, Object message, int maxDepth) {
        if (message == null) {
            return null;
        }
        return MessageTools.toSafeStringExpandedRecurse(evaluator, message, maxDepth);
    }

    public static String[] toStrings(IMessage[] messages) {
        return (String[])Arrays.stream(messages).map(message -> message.getString()).toArray(String[]::new);
    }

    private MessageTools() {
    }
}

