/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.message;

import de.intarsys.tools.message.CommonMessageBundle;
import de.intarsys.tools.message.CommonMessageBundleFactory;
import de.intarsys.tools.message.IMessageBundle;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeMessageBundle
extends CommonMessageBundle {
    private static final Logger Log = LoggerFactory.getLogger((String)"NLS");
    private final List<IMessageBundle> bundles;

    public CompositeMessageBundle(CommonMessageBundleFactory factory, String name, List<IMessageBundle> bundles) {
        super(factory, name, null);
        this.bundles = bundles;
    }

    @Override
    public Set<String> getCodes() {
        HashSet<String> codes = new HashSet<String>();
        this.bundles.forEach(bundle -> codes.addAll(bundle.getCodes()));
        return codes;
    }

    @Override
    public String getPattern(String code) {
        String result = this.bundles.stream().map(bundle -> bundle.getPattern(code)).filter(Objects::nonNull).findFirst().orElse(null);
        if (this.isLogMode()) {
            Log.info("ExtendedMessageBundle.getPattern,{},{},{}", new Object[]{this.getName(), code, result});
        }
        return result;
    }

    @Override
    public String getString(String code, Object ... args) {
        Object result = null;
        if (this.isRawMode()) {
            result = "{" + code + "}";
        } else {
            result = this.bundles.stream().map(bundle -> {
                if (bundle.getPattern(code) != null) {
                    return bundle.getString(code, args);
                }
                return null;
            }).filter(Objects::nonNull).findFirst().orElse(null);
            if (result == null) {
                result = this.getFallbackString(code, args);
            }
        }
        if (this.isLogMode()) {
            Log.info("ExtendedMessageBundle.getString,{},{},{}", new Object[]{this.getName(), code, result});
        }
        return result;
    }
}

