/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.message;

import de.intarsys.tools.message.CommonMessageBundleFactory;
import de.intarsys.tools.message.FormattedObject;
import de.intarsys.tools.message.GenericMessage;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.MessageTools;

public abstract class CommonMessageBundle
implements IMessageBundle {
    private final CommonMessageBundleFactory factory;
    private final String name;
    private final ClassLoader classLoader;

    protected CommonMessageBundle(CommonMessageBundleFactory factory, String name, ClassLoader classLoader) {
        this.factory = factory;
        this.name = name;
        this.classLoader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
    }

    @Override
    public String format(String pattern, Object ... args) {
        return MessageTools.format(pattern, args);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public CommonMessageBundleFactory getFactory() {
        return this.factory;
    }

    protected String getFallbackString(String key, Object ... objects) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(key);
        sb.append("}");
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                sb.append("[");
                sb.append(this.getFormattedObject(objects[i]));
                sb.append("]");
            }
        }
        return sb.toString();
    }

    protected Object getFormattedObject(Object object) {
        if (object instanceof FormattedObject) {
            return ((FormattedObject)object).getFormattedObject();
        }
        return object;
    }

    @Override
    public IMessage getMessage(String code, Object ... arg) {
        return new GenericMessage(this, code, arg);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected boolean isLogMode() {
        return this.getFactory().isLogMode();
    }

    protected boolean isRawMode() {
        return this.getFactory().isRawMode();
    }
}

