/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.message;

import de.intarsys.tools.message.CombinedResourceBundle;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedResourceBundleControl
extends ResourceBundle.Control {
    private static final Logger Log = LoggerFactory.getLogger(CombinedResourceBundleControl.class);

    private Properties load(String resourceName, ClassLoader loader) throws IOException {
        Properties result = new Properties();
        Enumeration<URL> urls = loader.getResources(resourceName);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            Log.debug("CombinedResourceBundleControl loading {} from {}", (Object)resourceName, (Object)url);
            Properties properties = new Properties();
            try (InputStream is = url.openStream();){
                properties.load(is);
            }
            result.putAll((Map<?, ?>)properties);
        }
        return result;
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        if (!"java.properties".equals(format)) {
            return super.newBundle(baseName, locale, format, loader, reload);
        }
        Log.debug("CombinedResourceBundleControl loading {} for locale {}", (Object)baseName, (Object)locale);
        String bundleName = this.toBundleName(baseName, locale);
        String resourceName = this.toResourceName(bundleName, "properties");
        Properties properties = this.load(resourceName, loader);
        return properties.size() == 0 ? null : new CombinedResourceBundle(properties);
    }
}

