/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.string.StringTools;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;

public class TransientLocator
extends CommonLocator {
    private boolean alwaysUnchanged;
    private String fullname;

    public TransientLocator(String pFullName) {
        this.setFullName(pFullName);
    }

    public TransientLocator(String name, String type) {
        if (name == null || type == null) {
            throw new NullPointerException("name and type may not be null for TransientLocator");
        }
        if (StringTools.isEmpty(type)) {
            this.setFullName(name);
        } else {
            this.setFullName(name + "." + this.canonical(type));
        }
    }

    private String canonical(String name) {
        return name.trim().toLowerCase();
    }

    @Override
    public void delete() throws IOException {
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public ILocator getChild(String name) {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    @Override
    public String getName() {
        return PathTools.getName(this.fullname);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    @Override
    public ILocator getParent() {
        return null;
    }

    @Override
    public String getPath() {
        return this.fullname;
    }

    @Override
    public IRandomAccess getRandomAccess() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    @Override
    public Reader getReader() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    @Override
    public Reader getReader(String encoding) throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    @Override
    public Writer getWriter() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    @Override
    public Writer getWriter(String encoding) throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    public boolean isAlwaysUnchanged() {
        return this.alwaysUnchanged;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isOutOfSynch() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    @Override
    public ILocator[] listLocators(ILocatorNameFilter filter) throws IOException {
        return new ILocator[0];
    }

    @Override
    public void rename(String newName) throws IOException {
        this.setFullName(newName);
    }

    public void setAlwaysUnchanged(boolean paramAlwaysUnchanged) {
        this.alwaysUnchanged = paramAlwaysUnchanged;
    }

    public void setFullName(String newName) {
        this.fullname = newName;
    }

    @Override
    public void synch() {
    }

    @Override
    public URI toURI() {
        return null;
    }
}

