/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.IPathFilter;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.util.function.Consumer;

public class LocatorWalker {
    public static final String PATH_SEPARATOR = "/";
    public static final IPathFilter ANY_FILTER = new IPathFilter(){

        @Override
        public boolean accept(String path) {
            return true;
        }
    };
    private IPathFilter filter;
    private boolean recursive = true;
    private boolean visitDirectories;
    private boolean visitFiles = true;
    private final ILocator root;

    public LocatorWalker(ILocator root) {
        if (root == null) {
            throw new IllegalArgumentException("root cannot be null");
        }
        this.root = root;
    }

    public void forEach(Consumer<LocatorWalkerNode> consumer) throws IOException {
        try {
            this.visit(this.getRoot(), "", consumer, true);
        }
        catch (Return return_) {
            // empty catch block
        }
    }

    public IPathFilter getFilter() {
        return this.filter;
    }

    public ILocator getRoot() {
        return this.root;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public boolean isVisitDirectories() {
        return this.visitDirectories;
    }

    public boolean isVisitFiles() {
        return this.visitFiles;
    }

    public void setFilter(IPathFilter filter) {
        this.filter = filter;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void setVisitDirectories(boolean visitDirectories) {
        this.visitDirectories = visitDirectories;
    }

    public void setVisitFiles(boolean visitFiles) {
        this.visitFiles = visitFiles;
    }

    protected void visit(ILocator locator, String path, Consumer<LocatorWalkerNode> consumer, boolean isSearchRoot) throws IOException {
        if (!isSearchRoot && this.getFilter() != null && !this.getFilter().accept(path)) {
            return;
        }
        if (locator.isDirectory()) {
            this.visitContainer(locator, path, consumer, isSearchRoot);
        } else {
            this.visitLeaf(locator, path, consumer);
        }
    }

    protected void visitContainer(ILocator locator, String path, Consumer<LocatorWalkerNode> consumer, boolean isSearchRoot) throws IOException {
        if (!isSearchRoot && this.isVisitDirectories()) {
            try {
                consumer.accept(new LocatorWalkerNode(locator, path));
            }
            catch (Continue e) {
                return;
            }
        }
        if (!this.isRecursive() && !isSearchRoot) {
            return;
        }
        ILocator[] children = locator.listLocators(null);
        for (int i = 0; i < children.length; ++i) {
            ILocator child = children[i];
            Object newPath = path;
            if (!StringTools.isEmpty((String)newPath)) {
                newPath = (String)newPath + PATH_SEPARATOR;
            }
            newPath = (String)newPath + child.getName();
            try {
                this.visit(child, (String)newPath, consumer, false);
                continue;
            }
            catch (Break e) {
                return;
            }
        }
    }

    protected void visitLeaf(ILocator locator, String path, Consumer<LocatorWalkerNode> consumer) throws IOException {
        if (this.isVisitFiles()) {
            consumer.accept(new LocatorWalkerNode(locator, path));
        }
    }

    public static class Return
    extends RuntimeException {
    }

    public static class LocatorWalkerNode {
        public final String path;
        public final ILocator locator;

        public LocatorWalkerNode(ILocator locator, String path) {
            this.locator = locator;
            this.path = path;
        }
    }

    public static class Continue
    extends RuntimeException {
    }

    public static class Break
    extends RuntimeException {
    }
}

