/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.locator.ClassLoaderResourceLocator;
import de.intarsys.tools.locator.CommonLocatorFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.string.PrettyPrinter;
import de.intarsys.tools.valueholder.IValueHolder;
import de.intarsys.tools.valueholder.ObjectHolder;
import java.io.IOException;

public class ClassLoaderResourceLocatorFactory
extends CommonLocatorFactory {
    private final IValueHolder<ClassLoader> classLoader;

    public ClassLoaderResourceLocatorFactory(ClassLoader classLoader) {
        this.classLoader = new ObjectHolder<ClassLoader>(classLoader);
    }

    public ClassLoaderResourceLocatorFactory(IValueHolder<ClassLoader> vh) {
        this.classLoader = vh;
    }

    @Override
    protected ILocator basicCreateLocator(String location) throws IOException {
        return new ClassLoaderResourceLocator(this.getClassLoader(), location);
    }

    public ClassLoader getClassLoader() {
        ClassLoader tempClassLoader = this.classLoader.get();
        if (tempClassLoader == null) {
            ClassLoader temp = Thread.currentThread().getContextClassLoader();
            if (temp == null) {
                temp = this.getClass().getClassLoader();
            }
            return temp;
        }
        return tempClassLoader;
    }

    @Override
    public void toString(PrettyPrinter printer) {
        printer.appendValue(this.getClass().getName() + " on " + this.getClassLoader());
    }
}

