/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.content.ICharsetAccess;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.string.StringTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;

public class ByteArrayLocator
extends CommonLocator
implements Serializable,
ICharsetAccess {
    private byte[] content;
    private int length;
    private boolean inSync = true;
    private String fullName;
    private String charset;

    public ByteArrayLocator(byte[] data, int length, String pFullName) {
        if (data == null) {
            data = new byte[length];
        }
        this.content = data;
        this.length = length;
        this.setFullName(pFullName);
    }

    public ByteArrayLocator(byte[] data, String pFullName) {
        this(data, data == null ? 0 : data.length, pFullName);
    }

    public ByteArrayLocator(byte[] data, String pName, String pType) {
        this(data, (String)(StringTools.isEmpty(pType) ? pName : pName + "." + pType));
    }

    public ByteArrayLocator(String pFullName) {
        this(null, 0, pFullName);
    }

    @Override
    public void delete() throws IOException {
    }

    @Override
    public boolean exists() {
        return this.content != null;
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.content, this.length);
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public ILocator getChild(String name) {
        return null;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.content, 0, this.length);
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public String getName() {
        return PathTools.getName(this.fullName);
    }

    @Override
    public OutputStream getOutputStream() {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                ByteArrayLocator.this.setContent(this.buf, this.count);
            }

            @Override
            public void flush() throws IOException {
                super.flush();
                ByteArrayLocator.this.setContent(this.buf, this.count);
            }
        };
    }

    @Override
    public ILocator getParent() {
        return null;
    }

    @Override
    public String getPath() {
        return this.fullName;
    }

    @Override
    public IRandomAccess getRandomAccess() {
        return new RandomAccessByteArray(this.content, this.length){

            @Override
            public void flush() throws IOException {
                super.flush();
                ByteArrayLocator.this.setContent(this.data, this.length);
            }
        };
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.getCharset() == null) {
            return new InputStreamReader(this.getInputStream());
        }
        return new InputStreamReader(this.getInputStream(), this.getCharset());
    }

    @Override
    public Reader getReader(String encoding) throws IOException {
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
        }
        return new InputStreamReader(this.getInputStream(), encoding);
    }

    @Override
    public Writer getWriter() throws IOException {
        if (this.getCharset() == null) {
            return new OutputStreamWriter(this.getOutputStream());
        }
        return new OutputStreamWriter(this.getOutputStream(), this.getCharset());
    }

    @Override
    public Writer getWriter(String encoding) throws IOException {
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
        }
        return new OutputStreamWriter(this.getOutputStream(), encoding);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isOutOfSynch() {
        return !this.inSync;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    @Override
    public ILocator[] listLocators(ILocatorNameFilter filter) {
        return new ILocator[0];
    }

    @Override
    public void rename(String newName) throws IOException {
        this.setFullName(newName);
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }

    protected void setContent(byte[] content, int length) {
        this.content = content;
        this.length = length;
        this.inSync = false;
    }

    protected void setFullName(String newName) {
        this.fullName = newName;
    }

    @Override
    public void synch() {
        this.inSync = true;
    }

    @Override
    public URI toURI() {
        return URI.create("bytes:[@]" + new String(Base64.encode(this.getBytes())));
    }
}

