/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.json;

import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.json.Json;
import de.intarsys.tools.json.JsonArray;
import de.intarsys.tools.json.JsonArrayArgs;
import de.intarsys.tools.json.JsonObject;
import java.util.Iterator;
import java.util.Set;

public class JsonObjectArgs
implements IArgs {
    private JsonObject json;

    protected static Object unwrap(Object value) {
        if (value instanceof JsonObject) {
            return new JsonObjectArgs((JsonObject)value);
        }
        if (value instanceof JsonArray) {
            return new JsonArrayArgs((JsonArray)value);
        }
        return value;
    }

    protected static Object wrap(Object value) {
        if (value instanceof IArgs) {
            value = ArgTools.toJavaDeep((IArgs)value);
        }
        return Json.wrap(value);
    }

    public JsonObjectArgs(JsonObject json) {
        this.json = json;
    }

    @Override
    public IArgs.IBinding add(Object object) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public Iterator<IArgs.IBinding> bindings() {
        return new ConversionIterator<String, IArgs.IBinding>(this.json.names().iterator()){

            @Override
            protected IArgs.IBinding createTargetObject(String key) {
                return new Binding(key);
            }
        };
    }

    @Override
    public void clear() {
        this.json.clear();
    }

    @Override
    public IArgs copy() {
        return new JsonObjectArgs(Json.copy(this.json));
    }

    @Override
    public IArgs.IBinding declare(String name) {
        return new Binding(name);
    }

    @Override
    public Object get(int index) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public Object get(int index, Object defaultValue) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public Object get(String name) {
        Object value = this.json.get(name);
        return JsonObjectArgs.unwrap(value);
    }

    @Override
    public Object get(String name, Object defaultValue) {
        Object value = this.get(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public boolean isDefined(int index) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public boolean isDefined(String name) {
        return this.json.has(name);
    }

    @Override
    public boolean isNamed() {
        return true;
    }

    @Override
    public Iterator<IArgs.IBinding> iterator() {
        return this.bindings();
    }

    @Override
    public Set<String> names() {
        return this.json.names();
    }

    @Override
    public IArgs.IBinding put(int index, Object value) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public IArgs.IBinding put(String name, Object value) {
        this.json.basicPut(name, JsonObjectArgs.wrap(value));
        return new Binding(name);
    }

    @Override
    public int size() {
        return this.json.size();
    }

    @Override
    public void undefine(int index) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public void undefine(String name) {
        this.json.remove(name);
    }

    private class Binding
    implements IArgs.IBinding {
        private String key;

        public Binding(String key) {
            this.key = key;
        }

        @Override
        public String getName() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return JsonObjectArgs.this.get(this.key);
        }

        @Override
        public boolean isDefined() {
            return JsonObjectArgs.this.isDefined(this.key);
        }

        @Override
        public void setName(String name) {
            throw new UnsupportedOperationException("not supported");
        }

        @Override
        public void setValue(Object value) {
            JsonObjectArgs.this.put(this.key, value);
        }
    }
}

