/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.hex;

import de.intarsys.tools.hex.HexRow;
import de.intarsys.tools.hex.HexTools;

public class HexData {
    private byte[] bytes;
    private int length;
    private int offset;
    private int rowWidth = 16;

    public HexData(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public HexData(byte[] bytes, int offset, int length) {
        byte[] newBytes = new byte[length];
        System.arraycopy(bytes, offset, newBytes, 0, length);
        this.bytes = newBytes;
        this.offset = 0;
        this.length = length;
    }

    protected byte[] basicGetBytes() {
        return this.bytes;
    }

    protected byte basicGetValue(int index) {
        return this.bytes[index];
    }

    protected void basicSetValue(int index, byte value) {
        if (index >= this.offset + this.length) {
            int newLength = index - this.offset + 1;
            byte[] newBytes = new byte[newLength];
            System.arraycopy(this.bytes, this.offset, newBytes, 0, this.length);
            this.bytes = newBytes;
            this.length = newLength;
            this.offset = 0;
        }
        this.bytes[index] = value;
    }

    public byte getCellValue(int row, int column) {
        return this.getRow(row).getCellValue(column);
    }

    public String getCellValueAsString(int row, int column) {
        return this.getRow(row).getCellValueAsString(column);
    }

    public HexRow getRow(int index) {
        return new HexRow(this, this.offset + index * this.rowWidth, this.rowWidth);
    }

    public int getRowCount() {
        return this.length / this.rowWidth + 1;
    }

    public HexRow[] getRows() {
        int count = this.getRowCount();
        HexRow[] rows = new HexRow[count];
        for (int i = 0; i < count; ++i) {
            rows[i] = this.getRow(i);
        }
        return rows;
    }

    public byte getValue(int index) {
        return this.basicGetValue(this.offset + index);
    }

    public String getValueAsString(int index) {
        return new String(HexTools.byteToHex(this.getValue(index) & 0xFF));
    }

    public void insertCellValue(int row, int column, byte value) {
        int index = row * this.rowWidth + column;
        int newLength = this.length + 1;
        byte[] newBytes = new byte[newLength];
        System.arraycopy(this.bytes, this.offset, newBytes, 0, index);
        newBytes[index] = value;
        System.arraycopy(this.bytes, this.offset + index, newBytes, index + 1, this.length - index);
        this.bytes = newBytes;
        this.length = newLength;
        this.offset = 0;
    }

    public int length() {
        return this.bytes.length;
    }

    public void removeCellValue(int row, int column) {
        int index = row * this.rowWidth + column;
        int newLength = this.length - 1;
        byte[] newBytes = new byte[newLength];
        System.arraycopy(this.bytes, this.offset, newBytes, 0, index);
        System.arraycopy(this.bytes, this.offset + index + 1, newBytes, index, this.length - index - 1);
        this.bytes = newBytes;
        this.length = newLength;
        this.offset = 0;
    }

    public void setCellValue(int row, int column, byte value) {
        this.getRow(row).setCellValue(column, value);
    }

    public void setCellValue(int row, int column, String value) {
        this.getRow(row).setCellValue(column, value);
    }

    public void setValue(int index, byte value) {
        this.basicSetValue(this.offset + index, value);
    }

    public void setValue(int index, String value) {
        this.basicSetValue(this.offset + index, (byte)HexTools.hexStringToInt(value));
    }

    public byte[] toBytes() {
        byte[] result = new byte[this.length];
        System.arraycopy(this.bytes, this.offset, result, 0, this.length);
        return result;
    }
}

