/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.util.Collection;
import java.util.stream.Stream;

public class ArgsBuilder {
    private final ArgsBuilder parent;
    private final IArgs args;

    public ArgsBuilder() {
        this.parent = null;
        this.args = Args.create();
    }

    protected ArgsBuilder(ArgsBuilder parent, IArgs current) {
        this.parent = parent;
        this.args = current;
    }

    public ArgsBuilder(IArgs args) {
        this.parent = null;
        this.args = args;
    }

    public ArgsBuilder add(Collection[] values) {
        for (Collection value : values) {
            this.args.add(value);
        }
        return this;
    }

    public ArgsBuilder add(Object value) {
        this.args.add(value);
        return this;
    }

    public ArgsBuilder add(Object[] values) {
        for (Object value : values) {
            this.args.add(value);
        }
        return this;
    }

    public ArgsBuilder add(Stream values) {
        values.forEach(value -> this.args.add(value));
        return this;
    }

    public ArgsBuilder argsClose() {
        return this.parent;
    }

    public ArgsBuilder argsOpen() {
        Args newArgs = Args.create();
        this.args.add(newArgs);
        return new ArgsBuilder(this, newArgs);
    }

    public ArgsBuilder argsOpen(String name) {
        Args newArgs = Args.create();
        this.args.put(name, (Object)newArgs);
        return new ArgsBuilder(this, newArgs);
    }

    public IArgs build() {
        return this.args;
    }

    public IArgs getArgs() {
        return this.args;
    }

    public ArgsBuilder put(int index, Object value) {
        this.args.put(index, value);
        return this;
    }

    public ArgsBuilder put(String name, Object value) {
        ArgTools.putPath(this.args, name, value);
        return this;
    }

    public ArgsBuilder putAll(IArgs other) {
        ArgTools.putAll(this.args, other);
        return this;
    }

    public ArgsBuilder putAllDeep(IArgs other) {
        ArgTools.putAllDeep(this.args, other);
        return this;
    }

    public ArgsBuilder putAllIfAbsent(IArgs other) {
        ArgTools.putAllIfAbsent(this.args, other);
        return this;
    }

    public ArgsBuilder putAllIfAbsentDeep(IArgs other) {
        ArgTools.putAllIfAbsentDeep(this.args, other);
        return this;
    }

    public ArgsBuilder putIfAbsent(String name, Object value) {
        ArgTools.putPathIfAbsent(this.args, name, value);
        return this;
    }
}

