/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import java.io.File;

public class WildcardMatch {
    private boolean ignoreCase = true;
    private boolean matchSeparators = true;

    protected char adjustCase(char c) {
        return this.ignoreCase ? Character.toLowerCase(c) : c;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean isMatchSeparators() {
        return this.matchSeparators;
    }

    public boolean match(String pattern, String string) {
        int len = pattern.length();
        int n = 0;
        int p = 0;
        while (p < len) {
            char c = this.adjustCase(pattern.charAt(p));
            switch (c) {
                case '?': {
                    if (string.length() == n) {
                        return false;
                    }
                    if (this.matchSeparators || string.charAt(n) != File.separatorChar) break;
                    return false;
                }
                case '*': {
                    if (++p == pattern.length()) {
                        while (string.length() > n) {
                            if (string.charAt(n) == File.separatorChar && !this.matchSeparators) {
                                return false;
                            }
                            ++n;
                        }
                        return true;
                    }
                    while (string.length() >= n) {
                        if (this.match(pattern.substring(p), string.substring(n))) {
                            return true;
                        }
                        if (n == string.length() || string.charAt(n) == File.separatorChar && !this.matchSeparators) {
                            return false;
                        }
                        ++n;
                    }
                    return false;
                }
                default: {
                    if (string.length() == n) {
                        return false;
                    }
                    if (c == this.adjustCase(string.charAt(n))) break;
                    return false;
                }
            }
            ++p;
            ++n;
        }
        return string.length() == n;
    }

    public void setIgnoreCase(boolean newIgnoreCase) {
        this.ignoreCase = newIgnoreCase;
    }

    public void setMatchSeparators(boolean newMatchSeparators) {
        this.matchSeparators = newMatchSeparators;
    }
}

