/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.file.IPathFilter;
import java.io.File;
import java.io.IOException;

public abstract class FileLoader {
    public static final String PATH_SEPARATOR = "/";
    public static final String DEFAULT_LANGUAGE = "en";
    protected static final String PROP_USERLANGUAGE = "user.language";

    protected FileLoader() {
    }

    protected boolean basicLoad(File file, boolean readOnly, boolean recursive, String path, IPathFilter filter) throws IOException {
        if (file.isDirectory()) {
            return this.basicLoadDirectory(file, readOnly, recursive, path, filter);
        }
        return this.basicLoadFile(file, readOnly, path);
    }

    protected boolean basicLoadDirectory(File file, boolean readOnly, boolean recursive, String path, IPathFilter filter) throws IOException {
        File[] files = file.listFiles();
        if (files == null) {
            return false;
        }
        for (int i = 0; i < files.length; ++i) {
            File childFile = files[i];
            String newPath = path + childFile.getName();
            if (recursive) {
                if (childFile.isDirectory()) {
                    newPath = newPath + PATH_SEPARATOR;
                }
                if (!filter.accept(newPath)) continue;
                this.basicLoad(childFile, readOnly, recursive, newPath, filter);
                continue;
            }
            if (!childFile.isFile() || !filter.accept(newPath)) continue;
            this.basicLoadFile(childFile, readOnly, path);
        }
        return true;
    }

    protected abstract boolean basicLoadFile(File var1, boolean var2, String var3) throws IOException;

    public boolean load(File file, boolean readOnly, boolean recursive) throws IOException {
        return this.load(file, readOnly, recursive, IPathFilter.ANY_FILTER);
    }

    public boolean load(File file, boolean readOnly, boolean recursive, IPathFilter filter) throws IOException {
        if (file == null || !file.exists()) {
            return false;
        }
        return this.basicLoad(file, readOnly, recursive, "", filter);
    }

    public boolean load(File parent, String filename, boolean readOnly, boolean recursive) throws IOException {
        return this.load(parent, filename, readOnly, recursive, IPathFilter.ANY_FILTER);
    }

    public boolean load(File parent, String filename, boolean readOnly, boolean recursive, IPathFilter filter) throws IOException {
        if (filename == null) {
            return false;
        }
        File file = new File(filename);
        if (!file.isAbsolute()) {
            file = new File(parent, filename);
        }
        return this.load(file, readOnly, recursive, filter);
    }

    public boolean loadNLS(File file, boolean readOnly, boolean recursive) throws IOException {
        if (file == null || !file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            String language = System.getProperty(PROP_USERLANGUAGE);
            File languageDir = new File(file, language);
            if (this.load(languageDir, readOnly, recursive)) {
                return true;
            }
            File defaultDir = new File(file, DEFAULT_LANGUAGE);
            return this.load(defaultDir, readOnly, recursive);
        }
        File parent = file.getParentFile();
        if (parent == null) {
            return false;
        }
        String basename = FileTools.getBaseName(file);
        String extension = FileTools.getExtension(file);
        String language = System.getProperty(PROP_USERLANGUAGE);
        File languageFile = new File(parent, basename + "_" + language + "." + extension);
        if (file.exists() && this.basicLoadFile(languageFile, readOnly, "")) {
            return true;
        }
        return this.basicLoadFile(file, readOnly, "");
    }

    public boolean loadNLS(File parent, String filename, boolean readOnly, boolean recursive) throws IOException {
        if (filename == null) {
            return false;
        }
        File file = new File(filename);
        if (!file.isAbsolute()) {
            file = new File(parent, filename);
        }
        return this.loadNLS(file, readOnly, recursive);
    }
}

