/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.factory;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IStartStop;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.factory.CommonDelegatingFactory;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.SimpleSingletonFactory;
import de.intarsys.tools.infoset.ElementProxy;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.proxy.IProxy;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeferredFactory
extends CommonDelegatingFactory
implements IProxy {
    private static final Logger Log = LoggerFactory.getLogger(DeferredFactory.class);
    private String resultClassName;
    private Class resultClass;
    private IProxy proxy;
    private IFactory realized;

    public DeferredFactory(Object context, IElement element) throws ObjectCreationException {
        try {
            this.setContext(context);
            this.configure(element);
        }
        catch (ConfigurationException e) {
            throw new ObjectCreationException(e);
        }
    }

    protected IFactory basicGetDelegate() {
        return this.realized;
    }

    protected Object basicGetRealized() {
        return this.realized;
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        String tempId = element.attributeValue("id", null);
        if (tempId == null) {
            tempId = element.attributeValue("class", null);
        }
        this.setId(tempId);
        this.resultClassName = element.attributeValue("resultClass", null);
        this.proxy = new ElementProxy(IFactory.class, element, this.getProxyClassAttribute(), this.getContext());
    }

    @Override
    public Object getActive() {
        if (this.basicGetRealized() == null) {
            return null;
        }
        return super.getActive();
    }

    public synchronized IFactory getDelegate() {
        if (this.realized == null) {
            try {
                this.realized = (IFactory)this.proxy.getRealized();
            }
            catch (Throwable t) {
                Log.warn("{} error creating delegate factory", this.getLogLabel(), (Object)t);
                this.realized = new SimpleSingletonFactory<Object>(this.getResultType(), null);
            }
            if (this.realized instanceof INotificationSupport) {
                this.getDispatcher().attach((INotificationSupport)((Object)this.realized));
            }
            if (this.isStarted() && this.realized instanceof IStartStop) {
                ((IStartStop)((Object)this.realized)).start();
            }
        }
        return this.realized;
    }

    @Override
    public List getInstances() {
        if (this.basicGetRealized() == null) {
            return new ArrayList();
        }
        return super.getInstances();
    }

    protected Object getLogLabel() {
        return this.toString() + " defined in " + this.getContext();
    }

    protected String getProxyClassAttribute() {
        return "class";
    }

    public Object getRealized() {
        return this.getDelegate();
    }

    protected String getResultClassName() {
        return this.resultClassName;
    }

    @Override
    public synchronized Class getResultType() {
        if (this.basicGetRealized() == null) {
            if (this.resultClass == null) {
                if (this.getResultClassName() == null) {
                    this.resultClass = Object.class;
                } else {
                    try {
                        this.resultClass = ClassTools.createClass(this.getResultClassName(), Object.class, this.getClassLoader());
                    }
                    catch (Throwable t) {
                        Log.warn(t.getMessage(), t);
                        this.resultClass = Object.class;
                    }
                }
            }
            return this.resultClass;
        }
        return super.getResultType();
    }

    @Override
    public int size() {
        if (this.basicGetRealized() == null) {
            return 0;
        }
        return super.size();
    }
}

