/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.factory;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IContextSupport;
import de.intarsys.tools.component.IInitializeable;
import de.intarsys.tools.factory.CommonFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.ArgumentDeclarator;
import de.intarsys.tools.functor.DeclarationBlock;
import de.intarsys.tools.functor.DeclarationException;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IArgsAccess;
import de.intarsys.tools.functor.IDeclarationBlock;
import de.intarsys.tools.functor.IDeclarationSupport;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.common.DeclarationIO;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.PreferencesTools;
import de.intarsys.tools.reflect.IClassLoaderAccess;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reflect.ObjectTools;
import jakarta.annotation.PostConstruct;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonInstantiatingFactory<T>
extends CommonFactory<T>
implements IDeclarationSupport {
    public static final String PREFS_ARGS = "args";
    private static final Logger Log = LoggerFactory.getLogger(CommonInstantiatingFactory.class);
    private IElement instanceConfiguration;
    private IDeclarationBlock declarationBlock = new DeclarationBlock(this);
    private final Object lockCreate = new Object();

    protected CommonInstantiatingFactory() {
    }

    protected abstract T basicCreateInstance(IArgs var1) throws ObjectCreationException;

    protected void basicCreateInstanceConfig(T object, IArgs args) throws ObjectCreationException {
        try {
            IElement configuration;
            if (object instanceof IArgsAccess) {
                ((IArgsAccess)object).setArgs(args);
            }
            ClassLoader classLoader = this.getClassLoader(args);
            boolean init = false;
            if (this.getInstanceConfiguration() != null) {
                init = true;
                if (object instanceof IElementConfigurable) {
                    ((IElementConfigurable)object).configure(this.getInstanceConfiguration());
                }
                ElementTools.setProperties(object, this.getInstanceConfiguration(), classLoader);
            }
            if ((configuration = this.getConfiguration(args)) != null) {
                init = true;
                if (object instanceof IElementConfigurable) {
                    ((IElementConfigurable)object).configure(configuration);
                }
                ElementTools.setProperties(object, configuration, classLoader);
            }
            if (init && object instanceof IInitializeable) {
                ((IInitializeable)object).initializeAfterConstruction();
            }
            ObjectTools.invokeMethodAnnotatedWith(object, PostConstruct.class);
        }
        catch (ObjectCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObjectCreationException(e);
        }
    }

    protected void basicCreateInstanceInit(T object, IArgs args) throws ObjectCreationException {
        ClassLoader classLoader;
        Object context;
        if (object instanceof IInitializeable) {
            ((IInitializeable)object).initializeAfterCreation();
        }
        if ((context = this.getContext(args)) != null && object instanceof IContextSupport) {
            try {
                ((IContextSupport)object).setContext(context);
            }
            catch (ConfigurationException e) {
                throw new ObjectCreationException(e);
            }
        }
        if ((classLoader = this.getClassLoader(args)) != null && object instanceof IClassLoaderAccess) {
            ((IClassLoaderAccess)object).setClassLoader(classLoader);
        }
    }

    protected T basicLookupInstance(IArgs args) {
        return null;
    }

    protected IArgs basicPrepareArgs(IArgs args) throws ObjectCreationException {
        IArgs localArgs = args.copy();
        this.preferencesMergeArgs(localArgs);
        try {
            new ArgumentDeclarator().apply(this.getDeclarationBlock(), localArgs);
        }
        catch (DeclarationException e) {
            throw new ObjectCreationException(e);
        }
        return localArgs;
    }

    @Override
    public void configure(IElement pElement) throws ConfigurationException {
        this.setInstanceConfiguration(pElement.element("instanceConfiguration"));
        super.configure(pElement);
        try {
            this.declarationBlock = new DeclarationBlock(this);
            new DeclarationIO().deserializeDeclarationBlock(this.declarationBlock, pElement);
        }
        catch (ObjectCreationException e) {
            throw new ConfigurationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T createInstance(IArgs args) throws ObjectCreationException {
        T object;
        boolean created = false;
        Object object2 = this.lockCreate;
        synchronized (object2) {
            object = this.basicLookupInstance(args);
            if (object == null && (object = this.basicCreateInstance(args = this.basicPrepareArgs(args))) != null) {
                created = true;
                this.basicCreateInstanceInit(object, args);
                this.basicCreateInstanceConfig(object, args);
            }
        }
        if (created) {
            Object callback = ArgTools.getObject(args, "onCreated", null);
            args.undefine("onCreated");
            if (callback instanceof Consumer) {
                try {
                    ((Consumer)callback).accept(object);
                }
                catch (Exception e) {
                    throw new ObjectCreationException("'onCreated' callback failed", (Throwable)e);
                }
            } else if (callback instanceof IFunctor) {
                FunctorCall call = FunctorCall.noargs(null);
                call.getArgs().put("object", object);
                try {
                    ((IFunctor)callback).perform(call);
                }
                catch (FunctorException e) {
                    throw new ObjectCreationException("'onCreated' callback failed", (Throwable)e);
                }
            } else if (callback != null) {
                Log.warn("{} callback 'onCreated' for {} not supported", (Object)this.getLabel(), callback);
                throw new ObjectCreationException("'onCreated' callback not supported");
            }
            this.triggerCreated(object);
        }
        return object;
    }

    @Override
    public IDeclarationBlock getDeclarationBlock() {
        return this.declarationBlock;
    }

    public IElement getInstanceConfiguration() {
        return this.instanceConfiguration;
    }

    @Override
    protected void preferencesInit(IPreferences preferences) {
        super.preferencesInit(preferences);
        if (this.getDeclarationBlock().size() > 0) {
            Args args = Args.create();
            try {
                new ArgumentDeclarator().apply(this.getDeclarationBlock(), args);
            }
            catch (DeclarationException e) {
                Log.warn(e.getMessage(), (Throwable)e);
            }
            if (args.size() > 0) {
                PreferencesTools.putArgsAll(preferences.node(PREFS_ARGS), args);
            }
        }
    }

    protected void preferencesMergeArgs(IArgs args) {
        PreferencesTools.mergeArgs(this.getPreferences().node(PREFS_ARGS), args);
    }

    public void setInstanceConfiguration(IElement instanceConfiguration) {
        this.instanceConfiguration = instanceConfiguration;
    }
}

