/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;

public class TimeResolver
implements IStringEvaluator {
    private AtomicLong lastUniqueMillis = new AtomicLong();

    @Override
    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        if (expression == null) {
            throw new EvaluationException("expression is null");
        }
        switch (expression) {
            case "now": {
                return Instant.now();
            }
            case "millis": {
                return System.currentTimeMillis();
            }
            case "uniquemillis": {
                return this.lastUniqueMillis.updateAndGet(oldMillis -> {
                    long newMillis;
                    while ((newMillis = System.currentTimeMillis()) == oldMillis) {
                    }
                    return newMillis;
                });
            }
        }
        throw new EvaluationException(String.format("can't evaluate '%s'", expression));
    }
}

