/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.tag.TagTools;

public class TagResolver
implements IStringEvaluator {
    private final Object object;

    public TagResolver(Object object) {
        this.object = object;
    }

    @Override
    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        if (expression.startsWith("meta.")) {
            String metaName;
            if (expression.length() < 5) {
                throw new EvaluationException("can't evaluate '" + expression + "'");
            }
            String suffix = expression.substring(5);
            int index = suffix.lastIndexOf(46);
            if (index <= 0 || index == expression.length()) {
                throw new EvaluationException("can't evaluate '" + expression + "'");
            }
            String tagName = suffix.substring(0, index);
            Object result = TagTools.getTagMeta(this.object, tagName, metaName = suffix.substring(index + 1), null);
            if (result != null) {
                return result;
            }
            throw new EvaluationException("can't evaluate '" + expression + "'");
        }
        String result = TagTools.getTagValue(this.object, expression, null);
        if (result != null) {
            return result;
        }
        throw new EvaluationException("can't evaluate '" + expression + "'");
    }

    public Object getObject() {
        return this.object;
    }
}

