/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;

public class StringEvaluatorTools {
    public static Object evaluate(IStringEvaluator evaluator, Object value) {
        return StringEvaluatorTools.evaluate(evaluator, value, Args.create());
    }

    public static Object evaluate(IStringEvaluator evaluator, Object value, IArgs args) {
        if (evaluator == null) {
            return value;
        }
        if (value instanceof String) {
            try {
                return evaluator.evaluate((String)value, args);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public static String evaluateString(IStringEvaluator evaluator, String value) {
        return StringEvaluatorTools.evaluateString(evaluator, value, Args.create());
    }

    public static String evaluateString(IStringEvaluator evaluator, String value, IArgs args) {
        if (evaluator == null) {
            return value;
        }
        if (value == null) {
            return null;
        }
        try {
            return StringTools.safeString(evaluator.evaluate(value, args));
        }
        catch (Exception exception) {
            return value;
        }
    }

    private StringEvaluatorTools() {
    }
}

