/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;
import java.util.regex.Pattern;

public class RestrictedStringEvaluator
implements IStringEvaluator {
    private IStringEvaluator delegate;
    private Pattern allowPattern;
    private Pattern blockPattern;

    public RestrictedStringEvaluator(IStringEvaluator delegate, Pattern allowPattern, Pattern blockPattern) {
        this.delegate = delegate;
        this.allowPattern = allowPattern;
        this.blockPattern = blockPattern;
    }

    @Override
    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        if (this.allowed(expression)) {
            return this.delegate.evaluate(expression, args);
        }
        throw new EvaluationException("Cannot evaluate expression: " + expression);
    }

    private boolean allowed(String expression) {
        return this.allowPattern != null && this.allowPattern.matcher(expression).matches() && (this.blockPattern == null || !this.blockPattern.matcher(expression).matches());
    }
}

