/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.ContainerResolver;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.ResolveAny;
import de.intarsys.tools.expression.ResolveProperty;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectTools;
import java.lang.reflect.Method;

public class ReflectiveResolver
extends ContainerResolver {
    private final Object object;
    private Method resolveAny;

    public ReflectiveResolver(Object object) {
        super('.', false, null);
        this.object = object;
    }

    @Override
    protected Object basicEvaluate(String expression, IArgs args) throws EvaluationException {
        Class<?> clazz = this.object.getClass();
        Method[] methods = clazz.getMethods();
        for (int index = methods.length - 1; index >= 0; --index) {
            ResolveAny annotAny;
            Method method = methods[index];
            ResolveProperty annotProperty = method.getAnnotation(ResolveProperty.class);
            if (annotProperty != null) {
                String property = annotProperty.property();
                if (!expression.equals(property)) continue;
                try {
                    return method.invoke(this.object, new Object[0]);
                }
                catch (Exception e) {
                    throw new EvaluationException("can't evaluate '" + expression + "' (" + method + ")", e);
                }
            }
            if (this.resolveAny != null || (annotAny = method.getAnnotation(ResolveAny.class)) == null) continue;
            this.resolveAny = method;
        }
        if (this.resolveAny != null) {
            try {
                return this.resolveAny.invoke(this.object, expression, args);
            }
            catch (Exception index) {
                // empty catch block
            }
        }
        try {
            return ObjectTools.get(this.object, expression);
        }
        catch (Exception e) {
            throw new EvaluationException("can't evaluate '" + expression + "'");
        }
    }
}

