/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.Expression;
import de.intarsys.tools.expression.ExpressionParser;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.NamespaceNotFound;
import de.intarsys.tools.expression.Parantheses;
import de.intarsys.tools.expression.ReflectiveResolver;
import de.intarsys.tools.expression.StringLiteral;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.FunctorInternalException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorRegistry;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessingDecorator
implements IStringEvaluator {
    public static final char PROCESSING_SEPARATOR = ':';
    public static final String ARG_SEPARATOR = ",";
    public static final char CLOSE_BRACE = ')';
    public static final char OPEN_BRACE = '(';
    public static final char CODE_REFLECTION = '.';
    public static final char CODE_FUNCTOR = '#';
    public static final char CODE_DEEPRECURSION = '*';
    public static final char CODE_SHALLOWRECURSION = '+';
    public static final char CODE_CONDITIONAL = '?';
    public static final char CODE_DEFAULTVALUE = '!';
    private static IFunctorRegistry FormattingFunctors;
    private static final String ARG_RECURSION = "de.intarsys.tools.expression.ProcessingDecorator.recursion";
    private static final Logger Log;
    private IStringEvaluator evaluator;
    private char separator = (char)58;
    private String separatorString = "" + this.separator;
    private IStringEvaluator recursionEvaluator;

    protected static Object formatFunctor(Object value, String format) throws FunctorException {
        IFunctorRegistry registry = ProcessingDecorator.getFormattingFunctors();
        if (registry == null) {
            return value;
        }
        int openBrace = format.indexOf(40);
        if (openBrace == -1) {
            openBrace = format.length();
        }
        int closeBrace = format.indexOf(41);
        String formatterId = format.substring(0, openBrace);
        String[] argStrings = openBrace < closeBrace ? format.substring(openBrace + 1, closeBrace).split(ARG_SEPARATOR) : new String[]{};
        IFunctor formatter = registry.lookupFunctor(formatterId);
        if (formatter == null) {
            throw new FunctorInternalException("formatter '" + formatterId + "' not found");
        }
        Args args = Args.createIndexed(value, argStrings);
        FunctorCall call = new FunctorCall(value, args);
        return formatter.perform(call);
    }

    public static IFunctorRegistry getFormattingFunctors() {
        return FormattingFunctors;
    }

    public static void setFormattingFunctors(IFunctorRegistry formattingFunctors) {
        FormattingFunctors = formattingFunctors;
    }

    public ProcessingDecorator(IStringEvaluator evaluator) {
        this.evaluator = evaluator;
        this.recursionEvaluator = evaluator;
    }

    @Override
    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        try {
            List<Expression> exprs = this.parse(expression);
            if (exprs.isEmpty()) {
                throw new EvaluationException("empty expression");
            }
            Object value = null;
            EvaluationException ex = null;
            Expression expr = exprs.get(0);
            try {
                if (expr.isString()) {
                    value = ((StringLiteral)expr).getValue();
                } else {
                    String valueExpression = expr.getCode().trim();
                    value = this.evaluator.evaluate(valueExpression, args);
                }
            }
            catch (NamespaceNotFound e) {
                throw e;
            }
            catch (EvaluationException e) {
                ex = e;
            }
            for (int i = 1; i < exprs.size(); ++i) {
                try {
                    value = this.evaluateInstruction(value, ex, args, exprs.get(i));
                    ex = null;
                    continue;
                }
                catch (EvaluationException e) {
                    ex = e;
                }
            }
            this.propagateException(ex);
            return value;
        }
        catch (IOException e) {
            throw new EvaluationException(e);
        }
    }

    protected Object evaluateConditional(Object value, IArgs args, String instruction) throws EvaluationException {
        String expression = instruction.substring(1).trim();
        boolean negate = false;
        if (expression.startsWith("!")) {
            negate = true;
            expression = expression.substring(1).trim();
        }
        Object instructionValue = this.evaluator.evaluate(expression, args);
        try {
            boolean ok = Boolean.TRUE.equals(ConverterRegistry.get().convert(instructionValue, Boolean.class));
            return ok ^ negate ? value : null;
        }
        catch (ConversionException e) {
            return null;
        }
    }

    protected Object evaluateDeepRecursion(Object value, IArgs args, String instruction) throws EvaluationException {
        int depth = (Integer)args.get(ARG_RECURSION, (Object)10);
        if (depth == -1) {
            return value;
        }
        if (value instanceof String) {
            args.put(ARG_RECURSION, (Object)(--depth));
            Object result = this.recursionEvaluator.evaluate((String)value, args);
            if (value.equals(result)) {
                return value;
            }
            return this.evaluateDeepRecursion(result, args, instruction);
        }
        return value;
    }

    protected Object evaluateDefaultValue(Object value, EvaluationException ex, IArgs args, String instruction) throws EvaluationException {
        if (ex != null || value == null || value instanceof String && StringTools.isEmpty((String)value)) {
            return this.evaluate(instruction.substring(1), args);
        }
        return value;
    }

    protected Object evaluateFunctor(Object value, IArgs args, String instruction) throws EvaluationException {
        try {
            return ProcessingDecorator.formatFunctor(value, instruction.substring(1));
        }
        catch (FunctorException e) {
            Log.warn("evaluate '{}' using '{}' failed", new Object[]{value, instruction, e});
            throw new EvaluationException(e.getCause() == null ? e : e.getCause());
        }
    }

    protected Object evaluateInstruction(Object value, EvaluationException ex, IArgs args, Expression expr) throws EvaluationException {
        if (expr == null) {
            this.propagateException(ex);
            return StringTools.format(value, "");
        }
        if (expr.isString()) {
            return this.evaluateInstruction(value, ex, args, ((StringLiteral)expr).getValue());
        }
        if (expr.isToken()) {
            return this.evaluateInstruction(value, ex, args, expr.getCode());
        }
        if (expr.isFunction()) {
            return this.evaluateInstruction(value, ex, args, expr.getCode());
        }
        if (expr.isParantheses()) {
            return this.evaluateInstruction(value, ex, args, ((Parantheses)expr).getNested());
        }
        this.propagateException(ex);
        return StringTools.format(value, "");
    }

    protected Object evaluateInstruction(Object value, EvaluationException ex, IArgs args, String instruction) throws EvaluationException {
        char c = instruction.charAt(0);
        if (c == '!') {
            return this.evaluateDefaultValue(value, ex, args, instruction);
        }
        if (c == '*' || c == '+') {
            this.propagateException(ex);
            return this.evaluateDeepRecursion(value, args, instruction);
        }
        if (c == '#') {
            this.propagateException(ex);
            return this.evaluateFunctor(value, args, instruction);
        }
        if (c == '?') {
            this.propagateException(ex);
            return this.evaluateConditional(value, args, instruction);
        }
        if (c == '.') {
            this.propagateException(ex);
            return this.evaluateReflection(value, args, instruction);
        }
        this.propagateException(ex);
        try {
            return StringTools.format(value, instruction);
        }
        catch (Exception e) {
            Log.warn("evaluate '{}' using '{}' failed", new Object[]{value, instruction, e});
            throw new EvaluationException("string formatting failed", e);
        }
    }

    protected Object evaluateReflection(Object value, IArgs args, String instruction) throws EvaluationException {
        ReflectiveResolver reflector = new ReflectiveResolver(value);
        return reflector.evaluate(instruction.substring(1), args);
    }

    public IStringEvaluator getEvaluator() {
        return this.evaluator;
    }

    public IStringEvaluator getRecursionEvaluator() {
        return this.recursionEvaluator;
    }

    public char getSeparator() {
        return this.separator;
    }

    public String getSeparatorString() {
        return this.separatorString;
    }

    protected void parse(List<Expression> exprs, StringReader reader) throws IOException {
        ExpressionParser parser = new ExpressionParser(':');
        Expression expr = parser.parse(reader);
        while (expr != null) {
            exprs.add(expr);
            expr = parser.parse(reader);
        }
    }

    protected List<Expression> parse(String expression) throws IOException {
        ArrayList<Expression> exprs = new ArrayList<Expression>(2);
        StringReader r = new StringReader(expression);
        this.parse(exprs, r);
        return exprs;
    }

    protected void propagateException(EvaluationException ex) throws EvaluationException {
        if (ex != null) {
            throw ex;
        }
    }

    public void setRecursionEvaluator(IStringEvaluator recursionEvaluator) {
        this.recursionEvaluator = recursionEvaluator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    static {
        Log = LoggerFactory.getLogger(ProcessingDecorator.class);
    }
}

