/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.environment.file.IFileEnvironment;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;

public class EnvironmentResolver
implements IStringEvaluator {
    private IFileEnvironment environment;

    public EnvironmentResolver() {
        this(null);
    }

    public EnvironmentResolver(IFileEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        IFileEnvironment tempEnvironment = this.environment;
        if (this.environment == null) {
            tempEnvironment = FileEnvironment.get();
        }
        if ("basedir".equals(expression)) {
            return tempEnvironment.getBaseDir().getAbsolutePath();
        }
        if ("profiledir".equals(expression)) {
            return tempEnvironment.getProfileDir().getAbsolutePath();
        }
        if ("datadir".equals(expression)) {
            return tempEnvironment.getDataDir().getAbsolutePath();
        }
        if ("workingdir".equals(expression)) {
            return tempEnvironment.getWorkingDir().getAbsolutePath();
        }
        if ("tempdir".equals(expression)) {
            return tempEnvironment.getTempDir().getAbsolutePath();
        }
        throw new EvaluationException("can't evaluate '" + expression + "'");
    }
}

