/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.dom;

import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LoggingErrorHandler
implements ErrorHandler {
    private static final AtomicInteger FILES_COUNTER = new AtomicInteger(1);
    private final Logger log;
    private int fileNumber = -1;
    private InputStream fileInputStream;

    public LoggingErrorHandler() {
        this(null);
    }

    public LoggingErrorHandler(Logger pLog) {
        this.log = pLog == null ? LoggerFactory.getLogger(LoggingErrorHandler.class) : pLog;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.log.error(e.getLocalizedMessage());
        this.logFile();
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.log.error(e.getLocalizedMessage());
        this.logFile();
    }

    private String getFileContent() {
        try {
            return StreamTools.getString(this.getFileInputStream(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return e.getLocalizedMessage();
        }
    }

    public Level getFileContentLogLevel() {
        return Level.DEBUG;
    }

    public InputStream getFileInputStream() {
        return this.fileInputStream;
    }

    private void logFile() {
        if (this.log.isEnabledForLevel(this.getFileContentLogLevel()) && this.fileInputStream != null) {
            if (this.fileNumber != -1) {
                this.log.atLevel(this.getFileContentLogLevel()).log("file number #" + this.fileNumber + " was logged above");
            } else {
                this.fileNumber = FILES_COUNTER.getAndIncrement();
                this.log.atLevel(this.getFileContentLogLevel()).log("file number #" + this.fileNumber + ", related to the error above:\n" + this.getFileContent());
            }
        }
    }

    public void setFileInputStream(InputStream fileInputStream) {
        this.fileInputStream = fileInputStream;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.log.warn(e.getLocalizedMessage());
    }
}

