/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.digest;

import de.intarsys.tools.digest.Digest;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.monitor.Trace;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import org.slf4j.event.Level;

public class Digester
implements IDigester {
    private MessageDigest messageDigest;
    private String algorithmName;

    protected Digester(String algorithmName, MessageDigest messageDigest) {
        this.messageDigest = messageDigest;
        this.algorithmName = algorithmName;
    }

    protected IDigest basicDigest() {
        byte[] digest = this.getMessageDigest().digest();
        return new Digest(this.getAlgorithmName(), digest);
    }

    @Override
    public IDigest digest(byte[] input) {
        try {
            Trace.get().sample(Level.DEBUG, "digest enter");
            this.getMessageDigest().update(input, 0, input.length);
            IDigest iDigest = this.basicDigest();
            return iDigest;
        }
        finally {
            Trace.get().sample(Level.DEBUG, "digest leave");
        }
    }

    @Override
    public IDigest digestFinal() {
        try {
            Trace.get().sample(Level.DEBUG, "digest enter");
            IDigest iDigest = this.basicDigest();
            return iDigest;
        }
        finally {
            Trace.get().sample(Level.DEBUG, "digest leave");
        }
    }

    @Override
    public void digestUpdate(InputStream is) throws IOException {
        int bufferSize = StreamTools.suggestBufferSize(is.available());
        byte[] buffer = new byte[bufferSize];
        int i = is.read(buffer);
        while (i != -1) {
            this.getMessageDigest().update(buffer, 0, i);
            i = is.read(buffer);
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public int getDigestLength() {
        return this.messageDigest.getDigestLength();
    }

    protected MessageDigest getMessageDigest() {
        return this.messageDigest;
    }

    @Override
    public void reset() {
        this.getMessageDigest().reset();
    }

    public String toString() {
        return this.getAlgorithmName();
    }
}

