/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto;

import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.ICryptdec;
import de.intarsys.tools.stream.StreamTools;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class DynamicCryptdec
implements ICryptdec {
    private static final int IV_LENGTH = 16;
    private final String id;
    private final String cipherId;
    private Cipher ecipher;
    private Cipher dcipher;
    private byte[] inBuffer;
    private final SecretKey key;

    public DynamicCryptdec(String id, SecretKey key, String cipherId) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.id = id;
        this.key = key;
        this.cipherId = cipherId;
    }

    @Override
    public byte[] decrypt(byte[] bytes) throws GeneralSecurityException {
        try {
            byte[] iv = Arrays.copyOfRange(bytes, 0, 16);
            IvParameterSpec ips = new IvParameterSpec(iv);
            this.dcipher = Cipher.getInstance(this.getCipherId());
            this.dcipher.init(2, (Key)this.getKey(), ips);
            byte[] byArray = this.dcipher.doFinal(bytes, 16, bytes.length - 16);
            return byArray;
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e.getMessage(), e);
        }
        finally {
            this.dcipher = null;
        }
    }

    @Override
    public void decryptFinal(OutputStream os) throws GeneralSecurityException {
        try {
            if (this.dcipher == null) {
                throw new GeneralSecurityException("invalid cipher state");
            }
            byte[] outBuffer = this.dcipher.doFinal();
            if (outBuffer != null) {
                os.write(outBuffer);
            }
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e.getMessage(), e);
        }
    }

    @Override
    public void decryptUpdate(InputStream is, OutputStream os) throws GeneralSecurityException {
        try {
            int i;
            this.ensureInBuffer(is);
            if (this.dcipher == null) {
                this.dcipher = Cipher.getInstance(this.getCipherId());
                byte[] iv = new byte[16];
                i = is.read(iv);
                if (i != 16) {
                    throw new GeneralSecurityException("input too short");
                }
                IvParameterSpec ips = new IvParameterSpec(iv);
                this.dcipher.init(2, (Key)this.getKey(), ips);
            }
            i = is.read(this.inBuffer);
            while (i != -1) {
                byte[] outBuffer = this.dcipher.update(this.inBuffer, 0, i);
                if (outBuffer != null) {
                    os.write(outBuffer);
                }
                i = is.read(this.inBuffer);
            }
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] encrypt(byte[] bytes) throws GeneralSecurityException {
        try {
            SecureRandom rand = CryptoTools.createSecureRandom();
            byte[] iv = new byte[16];
            rand.nextBytes(iv);
            IvParameterSpec ips = new IvParameterSpec(iv);
            this.ecipher = Cipher.getInstance(this.getCipherId());
            this.ecipher.init(1, (Key)this.getKey(), ips);
            byte[] byArray = ByteArrayTools.concat(iv, this.ecipher.doFinal(bytes));
            return byArray;
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e.getMessage(), e);
        }
        finally {
            this.ecipher = null;
        }
    }

    @Override
    public void encryptFinal(OutputStream os) throws GeneralSecurityException {
        try {
            if (this.ecipher == null) {
                throw new GeneralSecurityException("invalid cipher state");
            }
            byte[] outBuffer = this.ecipher.doFinal();
            if (outBuffer != null) {
                os.write(outBuffer);
            }
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e.getMessage(), e);
        }
        finally {
            this.ecipher = null;
        }
    }

    @Override
    public void encryptUpdate(InputStream is, OutputStream os) throws GeneralSecurityException {
        try {
            this.ensureInBuffer(is);
            if (this.ecipher == null) {
                this.ecipher = Cipher.getInstance(this.getCipherId());
                SecureRandom rand = CryptoTools.createSecureRandom();
                byte[] iv = new byte[16];
                rand.nextBytes(iv);
                IvParameterSpec ips = new IvParameterSpec(iv);
                this.ecipher.init(1, (Key)this.getKey(), ips);
                os.write(iv);
            }
            int i = is.read(this.inBuffer);
            while (i != -1) {
                byte[] outBuffer = this.ecipher.update(this.inBuffer, 0, i);
                if (outBuffer != null) {
                    os.write(outBuffer);
                }
                i = is.read(this.inBuffer);
            }
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e.getMessage(), e);
        }
    }

    protected void ensureInBuffer(InputStream is) {
        if (this.inBuffer == null) {
            this.inBuffer = new byte[StreamTools.suggestBufferSize(is)];
        }
    }

    public String getCipherId() {
        return this.cipherId;
    }

    protected Cipher getDcipher() {
        return this.dcipher;
    }

    protected Cipher getEcipher() {
        return this.ecipher;
    }

    @Override
    public String getId() {
        return this.id;
    }

    private SecretKey getKey() {
        return this.key;
    }
}

