/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.correlation;

import de.intarsys.tools.correlation.ICorrelationChangeListener;
import de.intarsys.tools.correlation.ICorrelationProvider;
import de.intarsys.tools.string.StringTools;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class CommonCorrelationProvider
implements ICorrelationProvider {
    private List<ICorrelationChangeListener> listeners = new CopyOnWriteArrayList<ICorrelationChangeListener>();

    public static String createCorrelationTag(String id) {
        return id;
    }

    @Override
    public void addChangeListener(ICorrelationChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void addCorrelationId(String id) {
        if (StringTools.isEmpty(id)) {
            return;
        }
        String previous = this.getCorrelationId();
        String tag = CommonCorrelationProvider.createCorrelationTag(id);
        Object next = tag;
        if (!StringTools.isEmpty(previous)) {
            if (previous.contains(tag)) {
                return;
            }
            next = previous + ";" + tag;
        }
        this.basicSetCorrelationId((String)next);
    }

    protected abstract void basicSetCorrelationId(String var1);

    @Override
    public void endCorrelation() {
        this.basicSetCorrelationId(null);
    }

    @Override
    public boolean removeChangeListener(ICorrelationChangeListener listener) {
        return this.listeners.remove(listener);
    }

    public void removeCorrelationId(String id) {
        if (StringTools.isEmpty(id)) {
            return;
        }
        String previous = this.getCorrelationId();
        if (!StringTools.isEmpty(previous)) {
            String tag = CommonCorrelationProvider.createCorrelationTag(id);
            String next = previous.replace(tag, "").replace(";;", ";");
            if (next.endsWith(";")) {
                next = next.substring(0, next.length() - 1);
            }
            this.basicSetCorrelationId(next);
        }
    }

    public void setCorrelationId(String id) {
        this.endCorrelation();
        this.addCorrelationId(id);
    }

    protected void triggerChange(String id) {
        for (ICorrelationChangeListener listener : this.listeners) {
            try {
                listener.changed(id);
            }
            catch (Exception exception) {}
        }
    }
}

