/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.converter;

import de.intarsys.tools.converter.Canonical;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.converter.IConverter;
import de.intarsys.tools.converter.Undefined;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DoubleDispatchConverter
implements IConverter<Object, Object> {
    private final Map<Class, List<IConverter>> registeredConverters = new HashMap<Class, List<IConverter>>();
    private final Map<Class, List<IConverter>> cachedConverters = new HashMap<Class, List<IConverter>>();
    private final Class targetType;

    public DoubleDispatchConverter(Class targetType) {
        this.targetType = targetType;
    }

    protected List<IConverter> computeConverters(Class clazz, ArrayList list) {
        List<IConverter> result = this.registeredConverters.get(clazz);
        if (result != null) {
            list.addAll(result);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            list.addAll(this.lookupConverters(interfaces[i]));
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            list.addAll(this.lookupConverters(superClass));
        }
        list.sort(new Comparator<IConverter>(){

            @Override
            public int compare(IConverter o1, IConverter o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        return list;
    }

    @Override
    public Object convert(Object source) throws ConversionException {
        List<IConverter> converters = this.lookupConverters(source);
        for (IConverter converter : converters) {
            Object result = converter.convert(source);
            if (result == null) continue;
            return result;
        }
        if (converters.isEmpty()) {
            if (this.targetType == Canonical.class) {
                throw new ConversionException("can't convert " + source.getClass().getName() + " to " + this.getTargetType());
            }
            Canonical canonical = ConverterRegistry.get().convert(source, Canonical.class);
            if (canonical == source) {
                throw new ConversionException("can't convert " + source.getClass().getName() + " to " + this.getTargetType());
            }
            return ConverterRegistry.get().convert(canonical, this.getTargetType());
        }
        return null;
    }

    @Override
    public Class<?> getSourceType() {
        return Object.class;
    }

    @Override
    public Class<?> getTargetType() {
        return this.targetType;
    }

    private List<IConverter> lookupConverters(Class<?> clazz) {
        List<IConverter> result = this.cachedConverters.get(clazz);
        if (result == null) {
            result = this.computeConverters(clazz, new ArrayList());
            this.cachedConverters.put(clazz, result);
        }
        return result;
    }

    protected List<IConverter> lookupConverters(Object source) {
        Class clazz = source == null ? Undefined.class : source.getClass();
        return this.lookupConverters(clazz);
    }

    public void registerConverter(IConverter converter) {
        this.registeredConverters.computeIfAbsent(converter.getSourceType(), c -> new ArrayList()).add(converter);
    }

    public void unregisterConverter(IConverter converter) {
        this.registeredConverters.computeIfAbsent(converter.getSourceType(), c -> new ArrayList()).remove(converter);
    }
}

