/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.concurrent;

import de.intarsys.tools.concurrent.AbstractPromise;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.function.Throwing;

public class Promise<V>
extends AbstractPromise<V> {
    public static Promise newCancelled() {
        Promise result = new Promise();
        result.cancel(false);
        return result;
    }

    public static Promise newFailed(String label, Throwable t) {
        Promise result = new Promise(label);
        result.fail(t);
        return result;
    }

    public static Promise newFailed(Throwable t) {
        Promise result = new Promise();
        result.fail(t);
        return result;
    }

    public static <V> Promise<V> newFinished(String label, V value) {
        Promise<V> result = new Promise<V>(label);
        result.finish(value);
        return result;
    }

    public static <V> Promise<V> newFinished(V value) {
        Promise<V> result = new Promise<V>();
        result.finish(value);
        return result;
    }

    public static <R> Promise<R> wrap(Throwing.Supplier<R> supplier) {
        try {
            return Promise.newFinished(supplier.get());
        }
        catch (Throwable e) {
            if (ExceptionTools.isCancellation(e)) {
                return Promise.newCancelled();
            }
            return Promise.newFailed(ExceptionTools.unwrap(e));
        }
    }

    public Promise() {
        this.created();
    }

    public Promise(String label) {
        super(label);
        this.created();
    }
}

