/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.concurrent;

import de.intarsys.tools.concurrent.EagerInitializer;
import de.intarsys.tools.concurrent.PrematureFutureTask;
import jakarta.annotation.PostConstruct;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EagerInitializable<R> {
    private static final Logger Log = LoggerFactory.getLogger(EagerInitializable.class);
    private Future<R> initializer;
    private final Object lock = new Object();

    protected Object basicGet() {
        try {
            return this.initializer.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Log.debug("{} eager initialization interrupted", (Object)this.getClass().getSimpleName());
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return null;
    }

    protected FutureTask<R> createNullInitializer() {
        return new PrematureFutureTask<Object>(() -> null);
    }

    protected FutureTask<R> createSynchronousInitializer() {
        if (this.isInitializationRequired()) {
            return new PrematureFutureTask<Object>(() -> this.initializeValueDecorated());
        }
        return this.createNullInitializer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object ensureInitialized() {
        Object object = this.lock;
        synchronized (object) {
            if (this.initializer == null) {
                this.initializer = this.createSynchronousInitializer();
            }
        }
        return this.basicGet();
    }

    @PostConstruct
    public void init() {
        this.initialize(EagerInitializer.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<R> initialize(ExecutorService executorService) {
        Object object = this.lock;
        synchronized (object) {
            if (this.initializer == null) {
                this.initializer = this.isEagerInitializable() ? executorService.submit(() -> this.initializeValueDecorated()) : this.createSynchronousInitializer();
            }
            return this.initializer;
        }
    }

    protected abstract R initializeValue();

    protected final R initializeValueDecorated() {
        try {
            R r = this.initializeValue();
            return r;
        }
        catch (RuntimeException e) {
            Log.warn("{} eager initialization failed", (Object)this.getClass().getSimpleName(), (Object)e);
            throw e;
        }
        finally {
            Log.debug("{} eager initialization finished", (Object)this.getClass().getSimpleName());
        }
    }

    protected boolean isEagerInitializable() {
        return true;
    }

    protected boolean isInitializationRequired() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitInitialized() {
        Object object = this.lock;
        synchronized (object) {
            if (this.initializer == null) {
                this.initializer = this.createNullInitializer();
            }
        }
        this.basicGet();
    }
}

