/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.concurrent;

import de.intarsys.tools.concurrent.IDeferredExecutor;
import de.intarsys.tools.concurrent.PrematureFutureTask;
import de.intarsys.tools.concurrent.ThreadTools;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DeferredExecutor
extends AbstractExecutorService
implements IDeferredExecutor {
    private ExecutorService executor;
    private final List<Runnable> runnables = new ArrayList<Runnable>();
    private boolean released = false;
    private Object lock = new Object();

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        Object object = this.lock;
        synchronized (object) {
            if (this.released) {
                this.executor.execute(command);
            } else {
                this.runnables.add(command);
            }
        }
    }

    protected int getExecutorPoolSize() {
        return 5;
    }

    @PostConstruct
    public void init() {
        ThreadPoolExecutor tmpExecutor = new ThreadPoolExecutor(this.getExecutorPoolSize(), this.getExecutorPoolSize(), 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ThreadTools.newThreadFactoryDaemon("EagerInitializer"));
        tmpExecutor.allowCoreThreadTimeOut(true);
        this.executor = tmpExecutor;
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new PrematureFutureTask<T>(callable);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new PrematureFutureTask<T>(runnable, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.lock;
        synchronized (object) {
            if (this.released) {
                return;
            }
            this.released = true;
            for (Runnable runnable : this.runnables) {
                this.execute(runnable);
            }
            this.runnables.clear();
        }
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }
}

