/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.component;

import de.intarsys.tools.component.ExpirationPredicate;

public class ExpireTimeout
extends ExpirationPredicate {
    private long touched;
    private final long expireAfter;

    public ExpireTimeout(long expireAfter) {
        this.expireAfter = expireAfter;
        this.touch();
    }

    @Override
    public ExpirationPredicate copy() {
        return new ExpireTimeout(this.getExpireAfter());
    }

    public long getExpireAfter() {
        return this.expireAfter;
    }

    public long getTouched() {
        return this.touched;
    }

    @Override
    public String getType() {
        return "timeout";
    }

    @Override
    public long getValue() {
        return this.getExpireAfter();
    }

    @Override
    public boolean isExpired() {
        if (this.getExpireAfter() <= 0L) {
            return false;
        }
        return System.currentTimeMillis() > this.getTouched() + this.getExpireAfter();
    }

    @Override
    protected void toString(StringBuilder sb) {
        sb.append("timeout(");
        sb.append(this.expireAfter);
        sb.append(")");
    }

    @Override
    public void touch() {
        this.touched = System.currentTimeMillis();
    }
}

