/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.collection;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.string.StringTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;

public final class ByteArrayTools {
    public static byte[] concat(byte[] ... arrays) {
        int length = 0;
        for (byte[] array : arrays) {
            length += array.length;
        }
        byte[] concat = new byte[length];
        int index = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, concat, index, array.length);
            index += array.length;
        }
        return concat;
    }

    public static byte[] copy(byte[] bytes) {
        byte[] newbuf = new byte[bytes.length];
        System.arraycopy(bytes, 0, newbuf, 0, bytes.length);
        return newbuf;
    }

    public static byte[] copy(byte[] bytes, int offset, int length) {
        byte[] newbuf = new byte[length];
        System.arraycopy(bytes, offset, newbuf, 0, length);
        return newbuf;
    }

    public static byte[] createBytes(int length, byte val) {
        byte[] bytes = new byte[length];
        Arrays.fill(bytes, val);
        return bytes;
    }

    public static byte[] createBytes(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            if (StringTools.isEmpty((String)value)) {
                return null;
            }
            value = Base64.decode((String)value);
        }
        if (value instanceof ILocator) {
            value = LocatorTools.getBytes((ILocator)value);
        }
        if (value instanceof ILocatorSupport) {
            value = LocatorTools.getBytes(((ILocatorSupport)value).getLocator());
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        try {
            return ConverterRegistry.get().convert(value, byte[].class);
        }
        catch (ConversionException e) {
            throw new IOException("can't convert " + value + " to byte[]");
        }
    }

    public static byte[] createRandomBytes(int length) {
        SecureRandom rand = CryptoTools.createSecureRandom();
        byte[] bytes = new byte[length];
        rand.nextBytes(bytes);
        return bytes;
    }

    public static boolean equals(byte[] array1, int offset1, byte[] array2, int offset2, int length) {
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length - offset1 < length || array2.length - offset2 < length) {
            return false;
        }
        if (length == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array1[offset1 + i] == array2[offset2 + i]) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(byte[] source, int sourceOffset, int sourceLen, byte[] pattern, int patternOffset, int patternLen, int fromIndex) {
        if (fromIndex >= sourceLen) {
            return patternLen == 0 ? sourceLen : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (patternLen == 0) {
            return fromIndex;
        }
        byte first = pattern[patternOffset];
        int max = sourceOffset + (sourceLen - patternLen);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + patternLen - 1;
            int k = patternOffset + 1;
            while (j < end && source[j] == pattern[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public static boolean startsWith(byte[] bytes, byte[] pattern) {
        if (bytes == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        if (pattern.length > bytes.length) {
            return false;
        }
        int length = pattern.length;
        for (int i = 0; i < length; ++i) {
            if (bytes[i] == pattern[i]) continue;
            return false;
        }
        return true;
    }

    public static int toBigEndianInt(byte[] buffer, int offset, int size) {
        size = size < 4 ? size : 4;
        size = size <= buffer.length - offset ? size : buffer.length - offset;
        int result = 0;
        int i = offset;
        if (i < offset + size) {
            result = buffer[i++];
        }
        while (i < offset + size) {
            result <<= 8;
            result |= buffer[i++] & 0xFF;
        }
        return result;
    }

    public static int toBigEndianIntUnsigned(byte[] buffer, int offset, int size) {
        size = size < 4 ? size : 4;
        size = size <= buffer.length - offset ? size : buffer.length - offset;
        int result = 0;
        for (int i = offset; i < offset + size; ++i) {
            result <<= 8;
            result |= buffer[i] & 0xFF;
        }
        return result;
    }

    public static long toBigEndianLong(byte[] buffer, int offset, int size) {
        size = size < 8 ? size : 8;
        size = size <= buffer.length - offset ? size : buffer.length - offset;
        int result = 0;
        int i = offset;
        if (i < offset + size) {
            result = buffer[i++];
        }
        while (i < offset + size) {
            result <<= 8;
            result |= buffer[i++] & 0xFF;
        }
        return result;
    }

    public static long toBigEndianLongUnsigned(byte[] buffer, int offset, int size) {
        size = size < 8 ? size : 8;
        size = size <= buffer.length - offset ? size : buffer.length - offset;
        int result = 0;
        for (int i = offset; i < offset + size; ++i) {
            result <<= 8;
            result |= buffer[i] & 0xFF;
        }
        return result;
    }

    public static byte[] toBytes(BigInteger r) {
        byte[] tmp = r.toByteArray();
        if (tmp[0] == 0) {
            byte[] ntmp = new byte[tmp.length - 1];
            System.arraycopy(tmp, 1, ntmp, 0, ntmp.length);
            return ntmp;
        }
        return tmp;
    }

    public static byte[] toBytes(BigInteger r, int size) {
        byte[] tmp = r.toByteArray();
        if (tmp.length == size) {
            return tmp;
        }
        byte[] result = new byte[size];
        int offset = size - tmp.length;
        if (tmp.length > size) {
            System.arraycopy(tmp, -offset, result, 0, size);
            return result;
        }
        int pad = r.signum() < 0 ? -1 : 0;
        for (int i = 0; i < offset; ++i) {
            result[i] = pad;
        }
        System.arraycopy(tmp, 0, result, offset, tmp.length);
        return result;
    }

    public static byte[] toBytesBigEndian(int value) {
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        do {
            byte byteVal = (byte)(value & 0xFF);
            byteList.add(byteVal);
        } while ((value >>= 8) != 0);
        int size = byteList.size();
        byte[] result = new byte[size];
        for (int i = size - 1; i >= 0; --i) {
            result[size - 1 - i] = (Byte)byteList.get(i);
        }
        return result;
    }

    public static byte[] toBytesBigEndian(int value, int size) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ByteArrayTools.writeBigEndian((OutputStream)os, value, size);
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] toBytesBigEndian(long value, int size) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ByteArrayTools.writeBigEndian((OutputStream)os, value, size);
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] toBytesLittleEndian(int value, int size) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ByteArrayTools.writeLittleEndian((OutputStream)os, value, size);
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] toBytesLittleEndian(long value, int size) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ByteArrayTools.writeLittleEndian((OutputStream)os, value, size);
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static int toLittleEndianInt(byte[] buffer, int offset, int size) {
        size = size < 4 ? size : 4;
        size = size <= buffer.length - offset ? size : buffer.length - offset;
        int result = 0;
        int i = offset + size - 1;
        if (i >= offset) {
            result = buffer[i--];
        }
        while (i >= offset) {
            result <<= 8;
            result |= buffer[i--] & 0xFF;
        }
        return result;
    }

    public static int toLittleEndianIntUnsigned(byte[] buffer, int offset, int size) {
        size = size < 4 ? size : 4;
        size = size <= buffer.length - offset ? size : buffer.length - offset;
        int result = 0;
        for (int i = offset + size - 1; i >= offset; --i) {
            result <<= 8;
            result |= buffer[i] & 0xFF;
        }
        return result;
    }

    public static long toLittleEndianLong(byte[] buffer, int offset, int size) {
        size = size < 8 ? size : 8;
        size = size <= buffer.length - offset ? size : buffer.length - offset;
        long result = 0L;
        int i = offset + size - 1;
        if (i >= offset) {
            result = buffer[i--];
        }
        while (i >= offset) {
            result <<= 8;
            result |= (long)(buffer[i--] & 0xFF);
        }
        return result;
    }

    public static long toLittleEndianLongUnsigned(byte[] buffer, int offset, int size) {
        size = size < 8 ? size : 8;
        size = size <= buffer.length - offset ? size : buffer.length - offset;
        long result = 0L;
        for (int i = offset + size - 1; i >= offset; --i) {
            result <<= 8;
            result |= (long)(buffer[i] & 0xFF);
        }
        return result;
    }

    public static void writeBigEndian(byte[] bytes, int start, int value, int size) throws IOException {
        int bitShift = 0;
        for (int i = start + size - 1; i >= start; --i) {
            bytes[i] = (byte)(value >>> bitShift & 0xFF);
            bitShift += 8;
        }
    }

    public static void writeBigEndian(IRandomAccess random, int value, int size) throws IOException {
        for (int i = size - 1; i >= 0; --i) {
            if (i >= 4) {
                random.write(0);
                continue;
            }
            random.write((byte)(value >>> 8 * i & 0xFF));
        }
    }

    public static void writeBigEndian(IRandomAccess random, long value, int size) throws IOException {
        for (int i = size - 1; i >= 0; --i) {
            if (i >= 8) {
                random.write(0);
                continue;
            }
            random.write((byte)(value >>> 8 * i & 0xFFL));
        }
    }

    public static void writeBigEndian(OutputStream os, int value, int size) throws IOException {
        for (int i = size - 1; i >= 0; --i) {
            if (i >= 4) {
                os.write(0);
                continue;
            }
            os.write((byte)(value >>> 8 * i & 0xFF));
        }
    }

    public static void writeBigEndian(OutputStream os, long value, int size) throws IOException {
        for (int i = size - 1; i >= 0; --i) {
            if (i >= 8) {
                os.write(0);
                continue;
            }
            os.write((byte)(value >>> 8 * i & 0xFFL));
        }
    }

    public static void writeLittleEndian(IRandomAccess random, int value, int size) throws IOException {
        for (int i = 0; i < size; ++i) {
            int bitShift = 8 * i;
            if (bitShift > 24) {
                random.write(0);
                continue;
            }
            random.write((byte)(value >>> bitShift & 0xFF));
        }
    }

    public static void writeLittleEndian(IRandomAccess random, long value, int size) throws IOException {
        for (int i = 0; i < size; ++i) {
            int bitShift = 8 * i;
            if (bitShift > 56) {
                random.write(0);
                continue;
            }
            random.write((byte)(value >>> bitShift & 0xFFL));
        }
    }

    public static void writeLittleEndian(OutputStream os, int value, int size) throws IOException {
        for (int i = 0; i < size; ++i) {
            int bitShift = 8 * i;
            if (bitShift > 24) {
                os.write(0);
                continue;
            }
            os.write((byte)(value >>> bitShift & 0xFF));
        }
    }

    public static void writeLittleEndian(OutputStream os, long value, int size) throws IOException {
        for (int i = 0; i < size; ++i) {
            int bitShift = 8 * i;
            if (bitShift > 56) {
                os.write(0);
                continue;
            }
            os.write((byte)(value >>> bitShift & 0xFFL));
        }
    }

    private ByteArrayTools() {
    }
}

