/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.codeexit;

import de.intarsys.tools.codeexit.CodeExit;
import de.intarsys.tools.codeexit.CommonCodeExitHandler;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.FunctorExecutionException;
import de.intarsys.tools.functor.FunctorInternalException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IArgumentDeclaration;
import de.intarsys.tools.functor.IDeclarationBlock;
import de.intarsys.tools.functor.IDeclarationElement;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class StaticMethodCodeExitHandler
extends CommonCodeExitHandler {
    protected IFunctor createMethod(CodeExit codeExit) throws FunctorException {
        this.checkCodeExitSource(codeExit);
        IFunctor functor = null;
        final String name = codeExit.getSource();
        try {
            int index = name.lastIndexOf(46);
            if (index <= 0) {
                throw new FunctorInternalException("illegal static method name '" + name + "'");
            }
            String classname = name.substring(0, index);
            String methodname = name.substring(index);
            if (!methodname.endsWith("()")) {
                throw new FunctorInternalException("illegal static method name '" + name + "'");
            }
            methodname = methodname.substring(1, methodname.length() - 2);
            Class<?> clazz = Class.forName(classname, true, codeExit.getClassLoader());
            final IDeclarationBlock declarationBlock = codeExit.getDeclarationBlock();
            Class[] parameterTypes = this.getParameterTypes(declarationBlock);
            try {
                final Method method = clazz.getMethod(methodname, parameterTypes);
                functor = new IFunctor(){

                    public Object perform(IFunctorCall call) throws FunctorException {
                        try {
                            Object[] parameters = StaticMethodCodeExitHandler.this.getParameters(declarationBlock, call);
                            return method.invoke(null, parameters);
                        }
                        catch (Throwable e) {
                            throw new FunctorExecutionException("static method invocation for " + name + " failed", e);
                        }
                    }
                };
                return functor;
            }
            catch (NoSuchMethodException method) {
                try {
                    final Method method2 = clazz.getMethod(methodname, IFunctorCall.class);
                    functor = new IFunctor(){

                        public Object perform(IFunctorCall call) throws FunctorException {
                            try {
                                return method2.invoke(null, call);
                            }
                            catch (Throwable e) {
                                throw new FunctorExecutionException("static method invocation for " + name + " failed", e);
                            }
                        }
                    };
                    return functor;
                }
                catch (NoSuchMethodException method2) {
                    final Method method3 = clazz.getMethod(methodname, IArgs.class);
                    functor = new IFunctor(){

                        public Object perform(IFunctorCall call) throws FunctorException {
                            try {
                                return method3.invoke(null, call.getArgs());
                            }
                            catch (Throwable e) {
                                throw new FunctorExecutionException("static method invocation for " + name + " failed", e);
                            }
                        }
                    };
                    return functor;
                }
            }
        }
        catch (Exception e) {
            throw new FunctorExecutionException("static method invocation for " + name + " failed", e);
        }
    }

    protected Object[] getParameters(IDeclarationBlock declarationBlock, IFunctorCall call) {
        ArrayList<Object> objects = new ArrayList<Object>();
        this.getParameters(declarationBlock, call, objects);
        return objects.toArray(new Object[objects.size()]);
    }

    protected void getParameters(IDeclarationBlock declarationBlock, IFunctorCall call, List<Object> objects) {
        if (declarationBlock == null) {
            return;
        }
        for (IDeclarationElement declaration : declarationBlock.getDeclarationElements()) {
            if (!(declaration instanceof IArgumentDeclaration)) continue;
            String name = ((IArgumentDeclaration)declaration).getName();
            Object value = call.getArgs().get(name);
            objects.add(value);
        }
    }

    protected Class[] getParameterTypes(IDeclarationBlock declarationBlock) {
        ArrayList<Class> declarations = new ArrayList<Class>();
        this.getParameterTypes(declarationBlock, declarations);
        return declarations.toArray(new Class[declarations.size()]);
    }

    protected void getParameterTypes(IDeclarationBlock declarationBlock, List<Class> declarations) {
        if (declarationBlock == null) {
            return;
        }
        for (IDeclarationElement declaration : declarationBlock.getDeclarationElements()) {
            if (!(declaration instanceof IArgumentDeclaration)) continue;
            declarations.add(((IArgumentDeclaration)declaration).getType());
        }
    }

    public Object perform(CodeExit codeExit, IFunctorCall call) throws FunctorException {
        IFunctor functor = (IFunctor)codeExit.getCompiledSource();
        if (functor == null) {
            functor = this.createMethod(codeExit);
            codeExit.setCompiledSource(functor);
        }
        return functor.perform(call);
    }
}

