/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.category;

import de.intarsys.tools.category.CategoryRegistry;
import de.intarsys.tools.category.GenericCategory;
import de.intarsys.tools.category.ICategory;
import de.intarsys.tools.category.ICategorySupport;
import de.intarsys.tools.presentation.PresentationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public final class CategoryTools {
    public static final ICategory ALL = new GenericCategory();

    public static List<ICategory> getCategories(List values, Predicate accept) {
        ArrayList<ICategory> categories = new ArrayList<ICategory>();
        for (Object object : values) {
            ICategory tempCategory;
            if (accept != null && !accept.test(object) || categories.contains(tempCategory = CategoryTools.getCategory(object))) continue;
            categories.add(tempCategory);
        }
        return categories;
    }

    public static List<ICategory> getCategoriesSorted(List values, Predicate accept) {
        List<ICategory> categories = CategoryTools.getCategories(values, accept);
        final PresentationHandler provider = new PresentationHandler(){

            @Override
            protected String basicGetLabel(Object object) {
                return ((ICategory)object).getId();
            }
        };
        Collections.sort(categories, new Comparator<ICategory>(){

            @Override
            public int compare(ICategory o1, ICategory o2) {
                return provider.getLabel(o1).compareTo(provider.getLabel(o2));
            }
        });
        return categories;
    }

    public static ICategory getCategory(Object object) {
        ICategory tempCategory;
        if (object instanceof ICategorySupport) {
            tempCategory = ((ICategorySupport)object).getCategory();
            if (tempCategory == null) {
                tempCategory = CategoryRegistry.get().lookupCategory("de.intarsys.category.other");
            }
        } else {
            tempCategory = CategoryRegistry.get().lookupCategory("de.intarsys.category.other");
        }
        return tempCategory;
    }

    public static Map<ICategory, List> getCategoryMap(List values, Predicate accept) {
        HashMap<ICategory, List> result = new HashMap<ICategory, List>();
        for (Object object : values) {
            if (accept != null && !accept.test(object)) continue;
            ICategory category = CategoryTools.getCategory(object);
            List elements = result.computeIfAbsent(category, ignore -> new ArrayList());
            elements.add(object);
        }
        return result;
    }

    public static List getValuesMatching(List pValues, Predicate accept, ICategory category) {
        ArrayList objects = new ArrayList();
        if (category != null) {
            for (Object object : pValues) {
                if (accept != null && !accept.test(object)) continue;
                ICategory tempCategory = CategoryTools.getCategory(object);
                if (category != ALL && !category.equals(tempCategory)) continue;
                objects.add(object);
            }
        }
        return objects;
    }

    private CategoryTools() {
    }
}

