/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.blocks;

import de.intarsys.tools.blocks.IBlock;
import de.intarsys.tools.blocks.IScope;
import java.util.function.Consumer;
import java.util.function.Function;

public class BlockFunction
implements IBlock {
    private final Function<IScope, Object> doTry;
    private final Consumer<IScope> doFinally;

    public BlockFunction(Function<IScope, Object> doTry, Consumer<IScope> doFinally) {
        this.doTry = doTry;
        this.doFinally = doFinally;
    }

    @Override
    public void runFinally(IScope scope) {
        if (this.doFinally != null) {
            scope.pop();
            this.doFinally.accept(scope);
        }
    }

    @Override
    public Object runTry(IScope scope) {
        if (this.doFinally != null) {
            scope.push(this);
        }
        if (this.doTry != null) {
            return this.doTry.apply(scope);
        }
        return null;
    }
}

