/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.activity.ui;

import de.intarsys.tools.activity.ReportStatus;
import de.intarsys.tools.activity.ui.IReportStatusUI;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.state.IState;
import de.intarsys.tools.string.StringTools;

public class ReportStatusUpdater {
    ReportStatus<?> reportStatus;
    IReportStatusUI ui;

    public ReportStatusUpdater(ReportStatus<?> reportStatus, IReportStatusUI ui) {
        this.reportStatus = reportStatus;
        this.ui = ui;
        this.reportStatus.addNotificationListener(AttributeChangedEvent.ID, new AttributeChangedListener());
    }

    public void updateReportStatus() {
        String taskName = this.reportStatus.getTaskName();
        String subTaskName = this.reportStatus.getSubTaskName();
        if (StringTools.isEmpty(taskName) && StringTools.isEmpty(subTaskName)) {
            this.ui.updateStatus(this, this.reportStatus.getMessage().getString());
        } else {
            this.ui.updateStatus(this, taskName, subTaskName, this.reportStatus.getWorkedPercent());
        }
    }

    private class AttributeChangedListener
    implements INotificationListener<AttributeChangedEvent> {
        private AttributeChangedListener() {
        }

        @Override
        public void handleEvent(AttributeChangedEvent event) {
            if (event.getAttribute().equals("state") && ((IState)event.getNewValue()).isFinal()) {
                ReportStatusUpdater.this.reportStatus.removeNotificationListener(AttributeChangedEvent.ID, this);
                ReportStatusUpdater.this.ui.clearStatus(ReportStatusUpdater.this);
            } else {
                ReportStatusUpdater.this.updateReportStatus();
            }
        }
    }
}

