/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.activity;

import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.activity.IActivityHandler;
import de.intarsys.tools.activity.IActivityView;
import de.intarsys.tools.activity.PACKAGE;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.component.IClassifiable;
import de.intarsys.tools.concurrent.IPromise;
import de.intarsys.tools.concurrent.ITaskCallback;
import de.intarsys.tools.concurrent.Promise;
import de.intarsys.tools.concurrent.SynchronousExecutorService;
import de.intarsys.tools.concurrent.TaskFailed;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.IMessageBundleSupport;
import de.intarsys.tools.message.PrefixedMessageBundle;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.reflect.InvocableArgument;
import de.intarsys.tools.reflect.InvocableMethod;
import de.intarsys.tools.reflect.ObjectTools;
import de.intarsys.tools.state.AtomicState;
import de.intarsys.tools.state.ComplexStateHolder;
import de.intarsys.tools.state.IState;
import de.intarsys.tools.ui.toolkit.Toolkit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonActivity<R, P extends IActivity<?>>
implements IActivity<R>,
IActivityHandler,
IPromise<R>,
IAttributeSupport,
IMessageBundleSupport,
INotificationSupport,
IClassifiable {
    private static final Logger Log = LoggerFactory.getLogger(CommonActivity.class);
    private final IAttributeSupport attributes = new AttributeMap();
    private final Promise<R> promise;
    private R deferredResult;
    private Throwable deferredException;
    private final String autoid;
    protected final Object lock = new Object();
    private final ComplexStateHolder stateHolder;
    private final EventDispatcher dispatcher;
    private final P parent;
    private final List<CommonActivity<?, ?>> children = new ArrayList();
    private IActivityHandler activityHandler;
    private IMessageBundle messageBundle;
    private final ITaskCallback<R> callbackPromise = new ITaskCallback<R>(){

        @Override
        public void failed(TaskFailed exception) {
            try {
                if (exception.isCancellation()) {
                    CommonActivity.this.enterState(CommonActivity.this.getStateCancelled());
                    CommonActivity.this.onCancelled();
                } else {
                    CommonActivity.this.enterState(CommonActivity.this.getStateFailed());
                    CommonActivity.this.onFailed(exception.getCause());
                }
            }
            finally {
                CommonActivity.this.onFinally();
            }
        }

        @Override
        public void finished(R result) {
            try {
                CommonActivity.this.enterState(CommonActivity.this.getStateOK());
                CommonActivity.this.onFinished(result);
            }
            finally {
                CommonActivity.this.onFinally();
            }
        }
    };
    private final IMessageBundle Msg = PACKAGE.Messages;
    private boolean modal;
    private boolean block = true;
    private boolean onTop;
    private ExecutorService executorService = this.createExecutor();

    protected CommonActivity() {
        this(null);
    }

    protected CommonActivity(P parent) {
        this.autoid = ObjectTools.createLabel(this);
        this.dispatcher = new EventDispatcher(this);
        this.promise = new Promise("Promise-" + this.autoid);
        this.addTaskCallback(this.callbackPromise);
        this.stateHolder = new ComplexStateHolder(this, this.dispatcher);
        this.stateHolder.setMessageBundle(new PrefixedMessageBundle(this.getMessageBundle(), ClassTools.getUnqualifiedName(this.getClass())));
        this.parent = parent;
    }

    public <RR> IActivityView activityEnter(IActivity<RR> activity) {
        IActivityHandler tempHandler = this.getActivityHandler();
        if (tempHandler != null) {
            return tempHandler.activityEnter(activity);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildActivity(CommonActivity<?, ?> activity) {
        Object object = this.lock;
        synchronized (object) {
            this.children.add(activity);
        }
    }

    @Override
    public <T extends Event> void addNotificationListener(EventType<? extends T> type, INotificationListener<T> listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    @Override
    public void addTaskCallback(ITaskCallback<R> callback) {
        this.promise.addTaskCallback(callback);
    }

    protected void basicEnterAfter() throws Exception {
    }

    protected void basicEnterBefore() throws Exception {
    }

    protected void basicPublishAfter() {
    }

    protected void basicPublishBefore() {
    }

    public final boolean cancel() {
        return this.cancel(false);
    }

    @Override
    @InvocableMethod
    public final boolean cancel(@InvocableArgument(name="interrupt") boolean interrupt) {
        if (this.isDone()) {
            return false;
        }
        this.logCancel();
        return this.promise.cancel(interrupt);
    }

    protected ExecutorService createExecutor() {
        return new SynchronousExecutorService();
    }

    public final boolean deferredCancel() {
        try {
            Log.debug("{} deferred cancel", (Object)this.getLogLabel());
            this.deferredException = ExceptionTools.cancellation();
            this.onDeferredCancelled();
            boolean bl = true;
            return bl;
        }
        finally {
            this.onDeferredFinally();
        }
    }

    public final void deferredFail(Throwable t) {
        try {
            Log.debug("{} deferred fail", (Object)this.getLogLabel());
            this.deferredException = t;
            this.onDeferredFailed(t);
        }
        finally {
            this.onDeferredFinally();
        }
    }

    public final void deferredFinish(R value) {
        try {
            Log.debug("{} deferred finish", (Object)this.getLogLabel());
            this.deferredResult = value;
            this.onDeferredFinished(value);
        }
        finally {
            this.onDeferredFinally();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deferredRelease() {
        Object object = this.lock;
        synchronized (object) {
            if (this.deferredException != null || this.deferredResult != null) {
                try {
                    this.finish(this.getDeferred());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.fail(e);
                }
                catch (ExecutionException e) {
                    this.fail(e.getCause());
                }
                catch (CancellationException e) {
                    this.cancel(false);
                }
            }
        }
    }

    @Override
    @InvocableMethod
    public final IActivityView enter() {
        try {
            this.basicEnterBefore();
            this.enterState(this.getStateActive());
            if (this.getParent() != null) {
                if (this.getParent() instanceof CommonActivity) {
                    ((CommonActivity)this.getParent()).addChildActivity(this);
                }
                if (this.getParent().isDone()) {
                    this.cancel(false);
                    return null;
                }
            }
            this.logEnterAfter();
            this.basicPublishBefore();
            if (this.isDone()) {
                return null;
            }
            IActivityView view = this.activityEnter(this);
            this.basicPublishAfter();
            this.basicEnterAfter();
            this.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        CommonActivity.this.execute();
                    }
                    catch (Throwable t) {
                        Log.error(t.getMessage(), t);
                    }
                    return null;
                }
            });
            return view;
        }
        catch (Exception e) {
            this.fail(e);
            return null;
        }
    }

    @Override
    public void enterState(IState pState) {
        Log.trace("{} enter state {}", (Object)this.getLogLabel(), (Object)pState.getId());
        this.stateHolder.enterState(pState);
    }

    protected void execute() throws Exception {
    }

    @Override
    public final void fail(Throwable t) {
        if (this.isDone()) {
            return;
        }
        Throwable cause = ExceptionTools.unwrap(t);
        if (ExceptionTools.isCancellation(cause)) {
            this.cancel();
            return;
        }
        this.logFail(cause);
        this.promise.fail(cause);
    }

    public final void failed(Throwable t) {
        this.fail(t);
    }

    @Override
    @InvocableMethod
    public final void finish(@InvocableArgument(name="value") R value) {
        if (!this.validate(value)) {
            this.logValidationFailure();
            return;
        }
        this.logFinish();
        this.promise.finish(value);
    }

    @Override
    public final R get() throws InterruptedException, ExecutionException {
        return this.promise.get();
    }

    @Override
    public final R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.promise.get(timeout, unit);
    }

    public IActivityHandler getActivityHandler() {
        if (this.activityHandler == null) {
            if (this.getParent() instanceof IActivityHandler) {
                return (IActivityHandler)this.getParent();
            }
            if (Toolkit.get() instanceof IActivityHandler) {
                return (IActivityHandler)((Object)Toolkit.get());
            }
        }
        return this.activityHandler;
    }

    public R getAnyway() {
        block3: {
            try {
                return this.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                Throwable cause = ExceptionTools.unwrap(e);
                if (ExceptionTools.isCancellation(cause)) break block3;
                Log.warn("activity failed", cause);
            }
        }
        return this.getAnywayFailure();
    }

    protected R getAnywayFailure() {
        return null;
    }

    @Override
    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    protected String getAutoid() {
        return this.autoid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CommonActivity<?, ?>> getChildren() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList(this.children);
        }
    }

    @Override
    @InvocableMethod
    public String getClassifier() {
        return this.getClass().getName();
    }

    protected IMessageBundle getDefaultMessageBundle() {
        if (this.getParent() instanceof IMessageBundleSupport) {
            return ((IMessageBundleSupport)this.getParent()).getMessageBundle();
        }
        return this.Msg;
    }

    protected R getDefaultResult() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final R getDeferred() throws InterruptedException, ExecutionException {
        Object object = this.lock;
        synchronized (object) {
            if (this.deferredException != null) {
                if (this.deferredException instanceof CancellationException) {
                    throw (CancellationException)this.deferredException;
                }
                throw new ExecutionException(this.deferredException);
            }
            return this.deferredResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final R getDeferred(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object object = this.lock;
        synchronized (object) {
            if (this.deferredException != null) {
                throw new ExecutionException(this.deferredException);
            }
            return this.deferredResult;
        }
    }

    protected EventDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public final Throwable getException() {
        try {
            this.promise.get();
            return null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return ExceptionTools.cancellation();
        }
        catch (ExecutionException e) {
            return e.getCause();
        }
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public String getLogLabel() {
        return this.autoid;
    }

    @Override
    public final IMessageBundle getMessageBundle() {
        if (this.messageBundle == null) {
            return this.getDefaultMessageBundle();
        }
        return this.messageBundle;
    }

    public P getParent() {
        return this.parent;
    }

    protected Promise<R> getPromise() {
        return this.promise;
    }

    public final String getStackTrace() {
        Throwable t = this.getException();
        if (t == null) {
            return null;
        }
        return ExceptionTools.getStackTraceString(t);
    }

    @Override
    public IState getState() {
        return this.stateHolder.getState();
    }

    protected AtomicState getStateActive() {
        return AtomicState.ACTIVE;
    }

    protected AtomicState getStateCancelled() {
        return AtomicState.CANCELLED;
    }

    protected AtomicState getStateFailed() {
        return AtomicState.FAILED;
    }

    protected AtomicState getStateOK() {
        return AtomicState.OK;
    }

    public boolean isBlock() {
        return this.block;
    }

    @Override
    public final boolean isCancelled() {
        return this.promise.isCancelled();
    }

    public final boolean isDeferredCancelled() {
        return this.deferredException instanceof CancellationException;
    }

    public final boolean isDeferredDone() {
        return this.deferredResult != null || this.deferredException != null;
    }

    @Override
    public final boolean isDone() {
        return this.promise.isDone();
    }

    public final boolean isFailed() {
        return this.promise.isFailed();
    }

    public boolean isModal() {
        return this.modal;
    }

    public boolean isOnTop() {
        return this.onTop;
    }

    protected void logCancel() {
        Log.debug("{} cancel", (Object)this.getLogLabel());
    }

    protected void logEnterAfter() {
        Log.debug("{} entered", (Object)this.getLogLabel());
    }

    protected void logFail(Throwable t) {
        Log.debug("{} fail {}", (Object)this.getLogLabel(), (Object)ExceptionTools.getMessage(t));
    }

    protected void logFinish() {
        Log.trace("{} finish", (Object)this.getLogLabel());
    }

    protected void logValidationFailure() {
        Log.trace("{} validation failure", (Object)this.getLogLabel());
    }

    @InvocableMethod
    public void ok() {
        this.finish(this.getDefaultResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCancelled() {
        ArrayList tempChildren;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            tempChildren = new ArrayList(this.children);
        }
        for (IActivity iActivity : tempChildren) {
            iActivity.cancel(false);
        }
    }

    protected void onDeferredCancelled() {
    }

    protected void onDeferredFailed(Throwable t) {
    }

    protected void onDeferredFinally() {
    }

    protected void onDeferredFinished(R result) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFailed(Throwable t) {
        ArrayList tempChildren;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            tempChildren = new ArrayList(this.children);
        }
        for (CommonActivity commonActivity : tempChildren) {
            commonActivity.fail(t);
        }
    }

    protected void onFinally() {
        this.onFinallyRelease();
        if (this.getParent() != null && this.getParent() instanceof CommonActivity) {
            ((CommonActivity)this.getParent()).removeChildActivity(this);
        }
    }

    protected void onFinallyRelease() {
        if (this.dispatcher != null) {
            this.dispatcher.clear();
        }
    }

    protected void onFinished(R result) {
    }

    public R peek() throws ExecutionException {
        if (this.promise.isDone()) {
            try {
                return this.promise.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ExecutionException(e);
            }
        }
        return null;
    }

    @Override
    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeChildActivity(IActivity<?> activity) {
        Object object = this.lock;
        synchronized (object) {
            this.children.remove(activity);
        }
    }

    @Override
    public <T extends Event> void removeNotificationListener(EventType<? extends T> type, INotificationListener<T> listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    @Override
    public void removeTaskCallback(ITaskCallback<R> callback) {
        this.promise.removeTaskCallback(callback);
    }

    public void setActivityHandler(IActivityHandler activityHandler) {
        this.activityHandler = activityHandler;
    }

    @Override
    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setMessageBundle(IMessageBundle messageBundle) {
        this.messageBundle = messageBundle;
    }

    public void setModal(boolean modal) {
        this.modal = modal;
    }

    public void setOnTop(boolean onTop) {
        this.onTop = onTop;
    }

    protected void submit(Callable<Void> callable) {
        this.getExecutorService().submit(callable);
    }

    public final void success(R value) {
        this.finish(value);
    }

    public String toString() {
        return this.getLogLabel();
    }

    protected void triggerChanged(Object attribute, Object oldValue, Object newValue) {
        this.dispatcher.triggerChanged(attribute, oldValue, newValue);
    }

    protected void triggerEvent(Event event) {
        this.dispatcher.triggerEvent(event);
    }

    protected boolean validate(R value) {
        return true;
    }
}

