/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.action;

import de.intarsys.tools.action.ActionAdapter;
import de.intarsys.tools.action.ActionForwarder;
import de.intarsys.tools.action.ActionRegistry;
import de.intarsys.tools.action.IAction;
import de.intarsys.tools.action.IActionRegistry;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;

public class ActionProxy
extends ActionForwarder
implements IElementConfigurable,
IElementSerializable {
    private IActionRegistry resolver;
    private String proxyId;

    public ActionProxy() {
    }

    public ActionProxy(IAction action) {
        super(action);
        this.proxyId = action.getId();
    }

    public ActionProxy(String proxyId, IActionRegistry resolver) {
        super(null);
        this.proxyId = proxyId;
        this.resolver = resolver;
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        this.setProxyId(element.attributeValue("id", null));
    }

    @Override
    public String getId() {
        return this.proxyId;
    }

    public String getProxyId() {
        return this.proxyId;
    }

    public IActionRegistry getResolver() {
        if (this.resolver == null) {
            return ActionRegistry.get();
        }
        return this.resolver;
    }

    @Override
    protected IAction resolve() {
        IAction resolved = this.getResolver().lookupAction(this.getId());
        if (resolved == null) {
            resolved = new ActionAdapter(){

                @Override
                public String getLabel() {
                    return "<missing proxy action '" + this.getId() + "'>";
                }
            };
        }
        return resolved;
    }

    @Override
    public void serialize(IElement element) throws ElementSerializationException {
        element.setAttributeValue("class", this.getClass().getName());
        element.setAttributeValue("id", this.getProxyId());
    }

    public void setProxyId(String proxyId) {
        this.proxyId = proxyId;
    }

    public void setResolver(IActionRegistry resolver) {
        this.resolver = resolver;
    }
}

