/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.action;

import de.intarsys.tools.action.IAction;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.functor.IFunctorCallFactory;
import de.intarsys.tools.reflect.IMethodHandler;
import de.intarsys.tools.reflect.IMethodHandlerAccessibility;
import de.intarsys.tools.reflect.MethodException;
import de.intarsys.tools.reflect.MethodExecutionException;
import de.intarsys.tools.reflect.ObjectCreationException;

public class ActionMethodHandler
implements IMethodHandler,
IMethodHandlerAccessibility {
    private final IAction action;
    private final String name;

    public static IMethodHandler create(IAction action) {
        if (action instanceof IMethodHandler) {
            return (IMethodHandler)((Object)action);
        }
        return new ActionMethodHandler(action.getId(), action);
    }

    public ActionMethodHandler(String name, IAction action) {
        this.name = name;
        this.action = action;
    }

    public IAction getAction() {
        return this.action;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Object invoke(Object receiver, IArgs args) throws MethodException {
        IFunctorCall call;
        if (this.action == null) {
            return null;
        }
        if (receiver instanceof IFunctorCallFactory) {
            try {
                call = ((IFunctorCallFactory)receiver).createFunctorCall(this.action, receiver, args);
            }
            catch (ObjectCreationException e) {
                throw new MethodExecutionException(this.getName(), (Throwable)e);
            }
        } else {
            call = new FunctorCall(receiver, args);
        }
        try {
            return this.action.perform(call);
        }
        catch (FunctorException e) {
            throw new MethodExecutionException(this.getName(), ExceptionTools.unwrap(e));
        }
    }

    @Override
    public boolean isInvokeEnabled(Object receiver, IArgs args) throws MethodException {
        IFunctorCall call;
        if (this.action == null) {
            return false;
        }
        if (receiver instanceof IFunctorCallFactory) {
            try {
                call = ((IFunctorCallFactory)receiver).createFunctorCall(this.action, receiver, args);
            }
            catch (ObjectCreationException e) {
                throw new MethodExecutionException(this.getName(), (Throwable)e);
            }
        } else {
            call = new FunctorCall(receiver, args);
        }
        try {
            return this.action.isEnabled(call);
        }
        catch (Exception e) {
            throw new MethodExecutionException(this.getName(), (Throwable)e);
        }
    }
}

