/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging.logback;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.read.CyclicBufferAppender;
import ch.qos.logback.core.util.StatusPrinter;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.logging.EnumLogLevel;
import de.intarsys.tools.logging.logback.ArgConverter;
import de.intarsys.tools.logging.logback.ArgsConverter;
import de.intarsys.tools.logging.slf4j.SLF4JBridgeHandler;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class LogbackTools {
    public static void configure(ILocator locator, Map<String, String> properties) {
        try {
            LogbackTools.configure(locator.getInputStream(), properties);
        }
        catch (IOException e) {
            System.out.println("LogbackProvider no configuration at " + locator.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configure(InputStream is, Map<String, String> properties) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                context.putProperty(entry.getKey(), entry.getValue());
            }
            configurator.doConfigure(is);
        }
        catch (Exception exception) {
        }
        finally {
            StreamTools.close((Closeable)is);
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
    }

    protected static FileAppender detectFileAppender(Iterator<Appender<ILoggingEvent>> it) {
        while (it.hasNext()) {
            Appender<ILoggingEvent> appender = it.next();
            if (appender instanceof AsyncAppender) {
                AsyncAppender aa = (AsyncAppender)appender;
                LogbackTools.detectFileAppender(aa.iteratorForAppenders());
                continue;
            }
            if (!(appender instanceof FileAppender)) continue;
            FileAppender fa = (FileAppender)appender;
            return fa;
        }
        return null;
    }

    public static URL getConfigurationURL() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        URL mainWatchURL = ConfigurationWatchListUtil.getMainWatchURL((Context)context);
        return mainWatchURL;
    }

    public static String getDefaultConfigurationName() {
        return "logback.xml";
    }

    public static File getLogDirectory() {
        Logger logger = LogbackTools.getRootLogger();
        Iterator it = logger.iteratorForAppenders();
        FileAppender appender = LogbackTools.detectFileAppender(it);
        if (appender != null) {
            return new File(appender.getFile()).getParentFile();
        }
        return null;
    }

    public static List<File> getLogFiles() {
        ArrayList<File> result = new ArrayList<File>();
        Logger logger = LogbackTools.getRootLogger();
        Iterator it = logger.iteratorForAppenders();
        FileAppender appender = LogbackTools.detectFileAppender(it);
        if (appender != null) {
            result.add(new File(appender.getFile()));
        }
        return result;
    }

    public static Logger getRootLogger() {
        return (Logger)LoggerFactory.getLogger((String)"ROOT");
    }

    public static boolean isConfigured() {
        URL mainWatchURL = LogbackTools.getConfigurationURL();
        return mainWatchURL != null;
    }

    public static void publishTo(CyclicBufferAppender source, Appender target) {
        if (target == null) {
            return;
        }
        int len = source.getLength();
        for (int i = 0; i < len; ++i) {
            Object event = source.get(i);
            target.doAppend(event);
        }
        source.reset();
    }

    public static Level toLevel(EnumLogLevel eLevel, Level defaultValue) {
        return LogbackTools.toLevel(eLevel.getLevel(), defaultValue);
    }

    public static Level toLevel(String name, Level defaultValue) {
        return Level.toLevel((String)name, (Level)defaultValue);
    }

    static {
        if (!SLF4JBridgeHandler.isInstalled()) {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
        }
        PatternLayout.DEFAULT_CONVERTER_MAP.put("arg", ArgConverter.class.getName());
        PatternLayout.DEFAULT_CONVERTER_MAP.put("args", ArgsConverter.class.getName());
    }
}

