/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.validation;

import de.intarsys.security.algorithm.common.Algorithm;
import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.app.validation.BasicTimestampEntryValidatorFactory;
import de.intarsys.security.app.validation.CommonSignatureContainerValidator;
import de.intarsys.security.app.validation.IDigestProvider;
import de.intarsys.security.app.validation.ITimestampEntryValidator;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.StaticDigestProvider;
import de.intarsys.security.method.cms.signature.CMSBasedSignatureContainer;
import de.intarsys.security.method.cms.validation.CMSBasedSignatureDigestProvider;
import de.intarsys.security.method.cms.validation.NoReferenceDataProvidedException;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.security.signature.ISignatureContainerEntry;
import de.intarsys.security.signature.ITimestampEntry;
import de.intarsys.security.standard.validation.CommonValidationMessages;
import de.intarsys.security.standard.validation.VSDigest;
import de.intarsys.security.standard.validation.VSSignatureContainer;
import de.intarsys.security.standard.validation.VSTimestamp;
import de.intarsys.security.standard.validation.VSTimestampEntry;
import de.intarsys.security.validation.IVSDigest;
import de.intarsys.security.validation.IVSSignatureContainer;
import de.intarsys.security.validation.IVSSignatureContainerEntry;
import de.intarsys.security.validation.IVSTimestamp;
import de.intarsys.security.validation.IVSTimestampEntry;
import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.tools.digest.IDigest;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;

public class TimestampTokenContainerValidator
extends CommonSignatureContainerValidator {
    public IVSSignatureContainer validate(ISignatureContainer signatureContainer, IDigest digest, IValidationParameters parameters) {
        CMSBasedSignatureContainer cmsSignatureContainer = (CMSBasedSignatureContainer)signatureContainer;
        CMSBasedSignatureDigestProvider digestProvider = null;
        digestProvider = digest == null ? new CMSBasedSignatureDigestProvider(cmsSignatureContainer) : new StaticDigestProvider(digest);
        VSSignatureContainer containerState = new VSSignatureContainer(signatureContainer);
        for (ISignatureContainerEntry entry : cmsSignatureContainer.getEntries()) {
            ITimestampEntry timestampEntry = (ITimestampEntry)entry;
            IVSTimestampEntry entryState = this.validate(timestampEntry, (IDigestProvider)digestProvider, parameters);
            containerState.addEntryState((IVSSignatureContainerEntry)entryState);
        }
        return containerState;
    }

    protected IVSTimestampEntry validate(ITimestampEntry timestampEntry, IDigestProvider digestProvider, IValidationParameters parameters) {
        IValidationMessage message;
        VSDigest digestState = new VSDigest();
        String algName = null;
        try {
            ITimestampEntryValidator entryValidator = BasicTimestampEntryValidatorFactory.get().createValidator(timestampEntry, this.getArgs());
            try {
                algName = timestampEntry.getTimestamp().getTimestampInfo().getMessageImprintAlgorithmName();
                DigestAlgorithm digestAlgorithm = DigestAlgorithm.lookupAlgorithmCanonical((String)algName);
                AlgorithmSpec digestAlgorithmSpec = new AlgorithmSpec((Algorithm)digestAlgorithm);
                IDigest digest = digestProvider.getDigest(digestAlgorithmSpec);
                return (IVSTimestampEntry)entryValidator.validate((ISignatureContainerEntry)timestampEntry, digest, parameters);
            }
            catch (NoReferenceDataProvidedException e) {
                IVSTimestampEntry entryState = (IVSTimestampEntry)entryValidator.validate((ISignatureContainerEntry)timestampEntry, null, parameters);
                return entryState;
            }
        }
        catch (NoSuchAlgorithmException e) {
            message = CommonValidationMessages.ERROR_ALGORITHM_UNKNOWN((Exception)e, algName);
            digestState = VSDigest.createInvalid((IValidationMessage)message);
        }
        catch (IOException e) {
            message = CommonValidationMessages.ERROR_IO((Exception)e);
            digestState = VSDigest.createInvalid((IValidationMessage)message);
        }
        VSTimestampEntry entryState = new VSTimestampEntry(timestampEntry);
        VSTimestamp timestampState = new VSTimestamp(timestampEntry.getTimestamp());
        timestampState.setDigestState((IVSDigest)digestState);
        entryState.setTimestampState((IVSTimestamp)timestampState);
        return entryState;
    }
}

