/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.encryption;

import de.intarsys.asn1.cms.EncryptedKey;
import de.intarsys.asn1.cms.KeyAgreeRecipientIdentifier;
import de.intarsys.asn1.cms.KeyAgreeRecipientInfo;
import de.intarsys.asn1.cms.KeyEncryptionAlgorithmIdentifier;
import de.intarsys.asn1.cms.OriginatorIdentifierOrKey;
import de.intarsys.asn1.cms.OriginatorPublicKey;
import de.intarsys.asn1.cms.RecipientEncryptedKey;
import de.intarsys.asn1.cms.RecipientEncryptedKeys;
import de.intarsys.asn1.cms.RecipientInfo;
import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.app.crypt.IEncryptedData;
import de.intarsys.security.app.crypt.IKeyEncryptedData;
import de.intarsys.security.app.crypt.symmetric.common.ISymmetricCryptHandler;
import de.intarsys.security.app.crypt.symmetric.common.SymmetricCryptHandlerRegistry;
import de.intarsys.security.app.crypt.symmetric.common.SymmetricEncryptorException;
import de.intarsys.security.app.encryption.IEncryptor;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.method.cms.encryption.CommonPKCS7RecipientInfoEncoder;
import de.intarsys.security.method.cms.encryption.EncryptorException;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECKey;
import java.security.spec.ECParameterSpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;

public class PKCS7RecipientInfoEncoderECDH
extends CommonPKCS7RecipientInfoEncoder {
    private static final Map<String, String> digestAlg2KeyAgreement = new HashMap<String, String>();
    private IDigester digester;
    private ISymmetricCryptHandler cekEncryptor;

    public PKCS7RecipientInfoEncoderECDH() {
        this.init();
    }

    @Override
    protected RecipientInfo basicEncode(byte[] cek, IEncryptor encryptor) throws EncryptorException {
        try {
            ECParameterSpec domainParams = this.getDomainParameters(encryptor.getCertificate().getPublicKey());
            KeyPair ephemeralPair = this.generateKeyPair(domainParams);
            PublicKey originatorPublicKey = ephemeralPair.getPublic();
            IEncryptedData encryptedData = encryptor.encrypt(ephemeralPair.getPrivate().getEncoded());
            byte[] secret = LocatorTools.getBytes((ILocator)encryptedData.getLocator());
            RecipientInfo recipientInfo = (RecipientInfo)RecipientInfo.FACTORY.createNew();
            KeyAgreeRecipientInfo keyAgreeRecipientInfo = this.encodeKeyAgreeRecipientInfo(cek, secret, encryptor.getCertificate(), originatorPublicKey);
            recipientInfo.setKeyAgreeRecipientInfo(keyAgreeRecipientInfo);
            return recipientInfo;
        }
        catch (GeneralSecurityException e) {
            throw new EncryptorException(e);
        }
        catch (Exception e) {
            throw new EncryptorException(e);
        }
    }

    protected KeyAgreeRecipientInfo encodeKeyAgreeRecipientInfo(byte[] cek, byte[] secret, IX509PublicKeyCertificate certificate, PublicKey originatorPublicKey) throws EncryptorException {
        try {
            IDigest secretHash = this.getDigester().digest(secret);
            String secretHashOid = DigestAlgorithm.lookupOID((String)secretHash.getAlgorithmName());
            byte[] kek = secretHash.getBytes();
            ISymmetricCryptHandler cekEncryptor = this.getCekEncryptor();
            SecretKeySpec sharedSecret = new SecretKeySpec(kek, cekEncryptor.getKeyAlgorithm());
            IKeyEncryptedData encryptedCek = cekEncryptor.encrypt(cek, (SecretKey)sharedSecret);
            KeyAgreeRecipientInfo keyAgreeRecipientInfo = (KeyAgreeRecipientInfo)KeyAgreeRecipientInfo.FACTORY.createNew();
            OriginatorIdentifierOrKey originator = (OriginatorIdentifierOrKey)OriginatorIdentifierOrKey.FACTORY.createNew();
            OriginatorPublicKey originatorKey = (OriginatorPublicKey)OriginatorPublicKey.FACTORY.createNew();
            originatorKey.setAlgorithm(AlgorithmIdentifier.create((String)"1.2.840.10045.2.1"));
            originatorKey.setPublicKey(originatorPublicKey.getEncoded());
            originator.setOriginatorKey(originatorKey);
            keyAgreeRecipientInfo.setOriginator(originator);
            String keyEncOid = digestAlg2KeyAgreement.get(secretHashOid);
            KeyEncryptionAlgorithmIdentifier keyEncAlgorithm = KeyEncryptionAlgorithmIdentifier.create((String)keyEncOid);
            AlgorithmIdentifier keyWrapAlgorithm = AlgorithmIdentifier.create((String)encryptedCek.getAlgorithmOID());
            keyEncAlgorithm.setParameters((ASN1Encodable)keyWrapAlgorithm);
            keyAgreeRecipientInfo.setKeyEncryptionAlgorithm(keyEncAlgorithm);
            RecipientEncryptedKeys recipientEncryptedKeys = (RecipientEncryptedKeys)RecipientEncryptedKeys.FACTORY.createNew();
            RecipientEncryptedKey recipientEncryptedKey = (RecipientEncryptedKey)RecipientEncryptedKey.FACTORY.createNew();
            KeyAgreeRecipientIdentifier rid = (KeyAgreeRecipientIdentifier)KeyAgreeRecipientIdentifier.FACTORY.createNew();
            rid.setIssuerAndSerialNumber(this.encodeIssuerAndSerialNumber(certificate));
            recipientEncryptedKey.setRid(rid);
            recipientEncryptedKey.setEncryptedKey(EncryptedKey.create((byte[])LocatorTools.getBytes((ILocator)encryptedCek.getLocator())));
            recipientEncryptedKeys.add(recipientEncryptedKey);
            keyAgreeRecipientInfo.setRecipientEncryptedKeys(recipientEncryptedKeys);
            return keyAgreeRecipientInfo;
        }
        catch (SymmetricEncryptorException e) {
            throw new EncryptorException(e);
        }
        catch (IOException e) {
            throw new EncryptorException(e);
        }
    }

    protected KeyPair generateKeyPair(ECParameterSpec domainParams) throws GeneralSecurityException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC", "BC");
        keyGen.initialize(domainParams, CryptoTools.createSecureRandom());
        return keyGen.generateKeyPair();
    }

    public ISymmetricCryptHandler getCekEncryptor() {
        return this.cekEncryptor;
    }

    public IDigester getDigester() {
        return this.digester;
    }

    protected ECParameterSpec getDomainParameters(Key key) {
        if (key instanceof ECKey) {
            return ((ECKey)((Object)key)).getParams();
        }
        throw new IllegalArgumentException("Cannot extract domain params");
    }

    protected void init() {
        String oid = "2.16.840.1.101.3.4.1.41";
        this.cekEncryptor = SymmetricCryptHandlerRegistry.get().lookupHandler(oid);
        if (this.cekEncryptor == null) {
            throw new IllegalStateException("Missing crypt support for algorithm " + oid + ". Please make sure the JEC Unlimited Strength Jurisdiction Policy Files are installed in the Java VM.");
        }
        try {
            this.digester = DigestTools.createDigester((String)"SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setCekEncryptor(ISymmetricCryptHandler cekEncryptor) {
        this.cekEncryptor = cekEncryptor;
    }

    public void setDigester(IDigester digester) {
        this.digester = digester;
    }

    static {
        digestAlg2KeyAgreement.put("1.3.14.3.2.26", "1.3.133.16.840.63.0.2");
        digestAlg2KeyAgreement.put("2.16.840.1.101.3.4.2.4", "1.3.132.1.11.0");
        digestAlg2KeyAgreement.put("2.16.840.1.101.3.4.2.1", "1.3.132.1.11.1");
        digestAlg2KeyAgreement.put("2.16.840.1.101.3.4.2.2", "1.3.132.1.11.2");
        digestAlg2KeyAgreement.put("2.16.840.1.101.3.4.2.3", "1.3.132.1.11.3");
    }
}

